/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="transformers", displayName="Data Type Transformers", description="Data-type transformer information")
public class TransformerConsole
extends AbstractDevConsole {
    public TransformerConsole() {
        super("camel", "transformers", "Data Type Transformers", "Data-type transformer information");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        TransformerRegistry reg = this.getCamelContext().getTransformerRegistry();
        sb.append(String.format("\n    Size: %s", reg.size()));
        sb.append(String.format("\n    Dynamic Size: %s", reg.dynamicSize()));
        sb.append(String.format("\n    Static Size: %s", reg.staticSize()));
        sb.append(String.format("\n    Maximum Cache Size: %s", reg.getMaximumCacheSize()));
        sb.append("\n");
        sb.append("\nTransformers:\n");
        for (Map.Entry entry : reg.entrySet()) {
            Transformer t = (Transformer)entry.getValue();
            String from = t.getFrom() != null ? t.getFrom().getFullName() : "*";
            String to = t.getTo() != null ? t.getTo().getFullName() : "*";
            sb.append(String.format("\n        %s (from: %s to: %s)", t.getName(), from, to));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        TransformerRegistry reg = this.getCamelContext().getTransformerRegistry();
        root.put("size", reg.size());
        root.put("dynamicSize", reg.dynamicSize());
        root.put("staticSize", reg.staticSize());
        root.put("maximumCacheSize", reg.getMaximumCacheSize());
        JsonArray arr = TransformerConsole.toJsonArray(reg);
        if (!arr.isEmpty()) {
            root.put("transformers", arr);
        }
        return root;
    }

    private static JsonArray toJsonArray(TransformerRegistry reg) {
        JsonArray arr = new JsonArray();
        for (Map.Entry entry : reg.entrySet()) {
            Transformer t = (Transformer)entry.getValue();
            String from = t.getFrom() != null ? t.getFrom().getFullName() : null;
            String to = t.getTo() != null ? t.getTo().getFullName() : null;
            JsonObject jo = new JsonObject();
            jo.put("name", t.getName());
            if (from != null) {
                jo.put("from", from);
            }
            if (to != null) {
                jo.put("to", to);
            }
            arr.add(jo);
        }
        return arr;
    }
}

