/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class Kamelet {
    public static final String PROPERTIES_PREFIX = "camel.kamelet.";
    public static final String ENV_VAR_PREFIX = "CAMEL_KAMELET_";
    public static final String SCHEME = "kamelet";
    public static final String SOURCE_ID = "source";
    public static final String SINK_ID = "sink";
    public static final String PARAM_ROUTE_ID = "routeId";
    public static final String PARAM_TEMPLATE_ID = "templateId";
    public static final String PARAM_LOCATION = "location";
    public static final String PARAM_UUID = "uuid";
    public static final String DEFAULT_LOCATION = "classpath:kamelets";
    public static final String NO_ERROR_HANDLER = "noErrorHandler";
    private static final UuidGenerator UUID = new SimpleUuidGenerator();

    private Kamelet() {
    }

    public static Predicate<String> startsWith(String prefix) {
        return item -> item.startsWith(prefix);
    }

    public static String extractTemplateId(CamelContext context, String remaining, Map<String, Object> parameters) {
        Object param = parameters.get(PARAM_TEMPLATE_ID);
        if (param != null) {
            return CamelContextHelper.mandatoryConvertTo(context, String.class, param);
        }
        if (SOURCE_ID.equals(remaining) || SINK_ID.equals(remaining)) {
            return context.resolvePropertyPlaceholders("{{templateId}}");
        }
        String answer = null;
        if (remaining != null) {
            answer = StringHelper.before(remaining, "/");
        }
        if (answer == null) {
            answer = remaining;
        }
        return answer;
    }

    public static String extractUuid() {
        return UUID.generateUuid();
    }

    public static String extractRouteId(CamelContext context, String remaining, Map<String, Object> parameters, String uuid) {
        Object param = parameters.get(PARAM_ROUTE_ID);
        if (param != null) {
            return CamelContextHelper.mandatoryConvertTo(context, String.class, param);
        }
        if (SOURCE_ID.equals(remaining) || SINK_ID.equals(remaining)) {
            return context.resolvePropertyPlaceholders("{{routeId}}");
        }
        Object answer = null;
        if (remaining != null) {
            answer = StringHelper.after(remaining, "/");
        }
        if (answer == null) {
            answer = Kamelet.extractTemplateId(context, remaining, parameters) + "-" + uuid;
        }
        return answer;
    }

    public static String extractLocation(CamelContext context, Map<String, Object> parameters) {
        Object param = parameters.get(PARAM_LOCATION);
        if (param != null) {
            return CamelContextHelper.mandatoryConvertTo(context, String.class, param);
        }
        return null;
    }

    public static void extractKameletProperties(CamelContext context, Map<String, Object> properties, String ... elements) {
        PropertiesComponent pc = context.getPropertiesComponent();
        StringBuilder prefixBuffer = new StringBuilder(PROPERTIES_PREFIX);
        for (String element : elements) {
            if (element == null) continue;
            prefixBuffer.append(element).append('.');
            Properties prefixed = pc.loadProperties(Kamelet.startsWith(prefixBuffer.toString()));
            for (String name : prefixed.stringPropertyNames()) {
                properties.put(name.substring(prefixBuffer.toString().length()), prefixed.getProperty(name));
            }
        }
    }

    public static void extractKameletEnvironmentVariables(Map<String, Object> properties, String ... elements) {
        String prefix;
        StringBuilder prefixBuffer = new StringBuilder(ENV_VAR_PREFIX);
        HashMap propertyMappings = new HashMap();
        for (String element : elements) {
            if (element == null) continue;
            prefixBuffer.append(IOHelper.normalizeEnvironmentVariable(element)).append('_');
            prefix = prefixBuffer.toString();
            System.getenv().keySet().stream().filter(Kamelet.startsWith(prefix)).forEach(name -> propertyMappings.put(name.substring(prefix.length()), name));
        }
        prefixBuffer = new StringBuilder(ENV_VAR_PREFIX);
        for (String element : elements) {
            if (element == null) continue;
            prefixBuffer.append(IOHelper.normalizeEnvironmentVariable(StringHelper.camelCaseToDash(element))).append('_');
            prefix = prefixBuffer.toString();
            System.getenv().keySet().stream().filter(Kamelet.startsWith(prefix)).forEach(name -> propertyMappings.put(name.substring(prefix.length()), name));
        }
        for (Map.Entry entry : propertyMappings.entrySet()) {
            String value = System.getenv((String)entry.getValue());
            if (value == null) continue;
            properties.put((String)entry.getKey(), value);
        }
    }

    public static RouteDefinition templateToRoute(RouteTemplateDefinition in, Map<String, Object> parameters) {
        String rid = (String)parameters.get(PARAM_ROUTE_ID);
        boolean noErrorHandler = (Boolean)parameters.get(NO_ERROR_HANDLER);
        String uuid = (String)parameters.get(PARAM_UUID);
        ObjectHelper.notNull(rid, PARAM_ROUTE_ID);
        ObjectHelper.notNull(uuid, PARAM_UUID);
        RouteDefinition def = in.asRouteDefinition();
        def.setKamelet(true);
        def.setLocation(in.getLocation());
        def.setLineNumber(in.getLineNumber());
        def.setId(rid);
        def.setNodePrefixId(uuid);
        if (noErrorHandler) {
            def.setErrorHandlerFactory(new NoErrorHandlerBuilder());
        }
        if (def.getInput() == null) {
            throw new IllegalArgumentException("Camel route " + rid + " input does not exist.");
        }
        if (def.getInput().getEndpointUri().startsWith("kamelet:source") || def.getInput().getEndpointUri().startsWith("kamelet://source")) {
            def.getInput().setUri("kamelet://source?routeId=" + rid);
        }
        int line = -1;
        boolean sink = false;
        Collection<ToDefinition> col = ProcessorDefinitionHelper.filterTypeInOutputs(def.getOutputs(), ToDefinition.class);
        for (ToDefinition to : col) {
            if (to.getEndpointUri().startsWith("kamelet:sink") || to.getEndpointUri().startsWith("kamelet://sink")) {
                to.setUri("kamelet://sink?routeId=" + rid);
                sink = true;
            }
            line = to.getLineNumber();
        }
        if (!sink) {
            ToDefinition to = new ToDefinition("kamelet://sink?routeId=" + rid);
            to.setLocation(def.getInput().getLocation());
            if (line != -1) {
                to.setLineNumber(line + 1);
            }
            def.getOutputs().add(to);
        }
        return def;
    }
}

