/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.reifier.ExpressionReifier;

public class RoutingSlipReifier
extends ExpressionReifier<RoutingSlipDefinition<?>> {
    public RoutingSlipReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (RoutingSlipDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Integer num;
        Expression expression = this.createExpression(((RoutingSlipDefinition)this.definition).getExpression());
        String delimiter = this.parseString(((RoutingSlipDefinition)this.definition).getUriDelimiter());
        if (delimiter == null) {
            delimiter = ",";
        }
        RoutingSlip routingSlip = new RoutingSlip(this.camelContext, expression, delimiter);
        if (((RoutingSlipDefinition)this.definition).getIgnoreInvalidEndpoints() != null) {
            routingSlip.setIgnoreInvalidEndpoints(this.parseBoolean(((RoutingSlipDefinition)this.definition).getIgnoreInvalidEndpoints(), false));
        }
        if ((num = this.parseInt(((RoutingSlipDefinition)this.definition).getCacheSize())) != null) {
            routingSlip.setCacheSize(num);
        }
        AsyncProcessor processor = routingSlip.newRoutingSlipProcessorForErrorHandler();
        AsyncProcessor errorHandler = (AsyncProcessor)this.wrapInErrorHandler(processor);
        routingSlip.setErrorHandler(errorHandler);
        return routingSlip;
    }
}

