/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.spi;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.spi.Configurer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;

@Configurer
public class KnativeEnvironment {
    private final List<KnativeResource> resources;

    public KnativeEnvironment() {
        this.resources = new ArrayList<KnativeResource>();
    }

    public KnativeEnvironment(Collection<KnativeResource> resources) {
        this.resources = new ArrayList<KnativeResource>(resources);
    }

    @JsonAlias(value={"services"})
    @JsonProperty(value="resources", required=true)
    public List<KnativeResource> getResources() {
        return this.resources;
    }

    @JsonAlias(value={"services"})
    @JsonProperty(value="resources", required=true)
    public void setResources(List<KnativeResource> resources) {
        this.resources.clear();
        this.resources.addAll(resources);
    }

    public Stream<KnativeResource> stream() {
        return this.resources.stream();
    }

    public Stream<KnativeResource> lookup(Knative.Type type, String name) {
        return this.stream().filter(definition -> definition.matches(type, name));
    }

    public static KnativeEnvironment mandatoryLoadFromSerializedString(String configuration) throws IOException {
        try (StringReader reader = new StringReader(configuration);){
            KnativeEnvironment knativeEnvironment = Knative.MAPPER.readValue((Reader)reader, KnativeEnvironment.class);
            return knativeEnvironment;
        }
    }

    public static KnativeEnvironment mandatoryLoadFromProperties(CamelContext context, Map<String, Object> properties) {
        ExtendedCamelContext econtext = context.getCamelContextExtension();
        KnativeEnvironment environment = new KnativeEnvironment();
        PropertyBindingSupport.build().withIgnoreCase(true).withCamelContext(context).withTarget(environment).withProperties(properties).withRemoveParameters(true).withConfigurer(PluginHelper.getConfigurerResolver(econtext).resolvePropertyConfigurer(KnativeEnvironment.class.getName(), context)).withMandatory(true).bind();
        return environment;
    }

    public static KnativeEnvironment mandatoryLoadFromResource(CamelContext context, String path) throws IOException {
        try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(context, path);){
            KnativeEnvironment knativeEnvironment = Knative.MAPPER.readValue(is, KnativeEnvironment.class);
            return knativeEnvironment;
        }
    }

    public static KnativeEnvironment on(KnativeResource ... definitions) {
        KnativeEnvironment env = new KnativeEnvironment();
        for (KnativeResource definition : definitions) {
            env.getResources().add(definition);
        }
        return env;
    }

    public static KnativeServiceBuilder serviceBuilder(Knative.Type type, String name) {
        return new KnativeServiceBuilder(type, name);
    }

    public static final class KnativeServiceBuilder {
        private final Knative.Type type;
        private final String name;
        private Knative.EndpointKind endpointKind;
        private String url;
        private Map<String, String> metadata;

        public KnativeServiceBuilder(Knative.Type type, String name) {
            this.type = type;
            this.name = name;
        }

        public KnativeServiceBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public KnativeServiceBuilder withUrlf(String format, Object ... args) {
            return this.withUrl(String.format(format, args));
        }

        public KnativeServiceBuilder withEndpointKind(Knative.EndpointKind endpointKind) {
            this.endpointKind = endpointKind;
            return this;
        }

        public KnativeServiceBuilder withMeta(Map<String, String> metadata) {
            if (metadata == null) {
                return this;
            }
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(metadata);
            return this;
        }

        public KnativeServiceBuilder withMeta(String key, String value) {
            if (key == null || value == null) {
                return this;
            }
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public KnativeServiceBuilder withMeta(String key, Enum<?> e) {
            if (key == null || e == null) {
                return this;
            }
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, e.name());
            return this;
        }

        public KnativeResource build() {
            KnativeResource answer = new KnativeResource();
            answer.setType(this.type);
            answer.setEndpointKind(this.endpointKind);
            answer.setName(this.name);
            answer.setUrl(this.url);
            answer.setMetadata(this.metadata);
            return answer;
        }
    }
}

