/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.health.HasHealthChecks;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.impl.health.DefaultHealthChecksLoader;
import org.apache.camel.impl.health.HealthCheckRegistryRepository;
import org.apache.camel.spi.HasId;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.HealthCheck(value="default-registry")
@DeferredContextBinding
public class DefaultHealthCheckRegistry
extends ServiceSupport
implements HealthCheckRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHealthCheckRegistry.class);
    private String id = "camel-health";
    private final Set<HealthCheck> checks;
    private final Set<HealthCheckRepository> repositories;
    private CamelContext camelContext;
    private boolean enabled = true;
    private String excludePattern;
    private String exposureLevel = "default";
    private HealthCheck.State initialState = HealthCheck.State.DOWN;
    private volatile boolean loadHealthChecksDone;

    public DefaultHealthCheckRegistry() {
        this(null);
    }

    public DefaultHealthCheckRegistry(CamelContext camelContext) {
        this.checks = new CopyOnWriteArraySet<HealthCheck>();
        this.repositories = new CopyOnWriteArraySet<HealthCheckRepository>();
        this.setCamelContext(camelContext);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getExcludePattern() {
        return this.excludePattern;
    }

    @Override
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    @Override
    public String getExposureLevel() {
        return this.exposureLevel;
    }

    @Override
    public void setExposureLevel(String exposureLevel) {
        this.exposureLevel = exposureLevel;
    }

    @Override
    public HealthCheck.State getInitialState() {
        return this.initialState;
    }

    @Override
    public void setInitialState(HealthCheck.State initialState) {
        this.initialState = initialState;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        Optional<HealthCheckRepository> hcr = this.repositories.stream().filter(repository -> repository instanceof HealthCheckRegistryRepository).findFirst();
        if (hcr.isEmpty()) {
            this.register(new HealthCheckRegistryRepository());
        }
        for (HealthCheck check : this.checks) {
            CamelContextAware.trySetCamelContext(check, this.camelContext);
        }
        for (HealthCheckRepository repository2 : this.repositories) {
            CamelContextAware.trySetCamelContext(repository2, this.camelContext);
        }
        ServiceHelper.initService(this.repositories, this.checks);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.repositories, this.checks);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.repositories, this.checks);
    }

    @Override
    public final void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public final CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Object resolveById(String id) {
        HasId answer = this.resolveHealthCheckById(id);
        if (answer == null) {
            answer = this.resolveHealthCheckRepositoryById(id);
        }
        CamelContextAware.trySetCamelContext(answer, this.camelContext);
        return answer;
    }

    private HealthCheck resolveHealthCheckById(String id) {
        HealthCheck answer = this.checks.stream().filter(h -> h.getId().equals(id)).findFirst().orElse(this.camelContext.getRegistry().findByTypeWithName(HealthCheck.class).get(id));
        if (answer == null) {
            HealthCheckResolver resolver = PluginHelper.getHealthCheckResolver(this.camelContext);
            answer = resolver.resolveHealthCheck(id);
        }
        return answer;
    }

    private HealthCheckRepository resolveHealthCheckRepositoryById(String id) {
        HealthCheckRepository answer = this.repositories.stream().filter(h -> h.getId().equals(id)).findFirst().orElse(this.camelContext.getRegistry().findByTypeWithName(HealthCheckRepository.class).get(id));
        if (answer == null) {
            HealthCheckResolver resolver = PluginHelper.getHealthCheckResolver(this.camelContext);
            answer = resolver.resolveHealthCheckRepository(id);
        }
        return answer;
    }

    @Override
    public boolean register(Object obj) {
        boolean result;
        this.checkIfAccepted(obj);
        CamelContextAware.trySetCamelContext(obj, this.camelContext);
        if (obj instanceof HealthCheck) {
            HealthCheck healthCheck = (HealthCheck)obj;
            if (this.getCheck(healthCheck.getId()).isPresent()) {
                return false;
            }
            result = this.checks.add(healthCheck);
            if (result) {
                CamelContextAware.trySetCamelContext(obj, this.camelContext);
                LOG.debug("HealthCheck with id {} successfully registered", (Object)healthCheck.getId());
            }
        } else {
            HealthCheckRepository repository = (HealthCheckRepository)obj;
            if (this.getRepository(repository.getId()).isPresent()) {
                return false;
            }
            result = this.repositories.add(repository);
            if (result) {
                CamelContextAware.trySetCamelContext(repository, this.camelContext);
                LOG.debug("HealthCheckRepository with id {} successfully registered", (Object)repository.getId());
            }
        }
        if (this.isStarted()) {
            ServiceHelper.startService(obj);
        }
        return result;
    }

    @Override
    public boolean unregister(Object obj) {
        boolean result;
        this.checkIfAccepted(obj);
        if (obj instanceof HealthCheck) {
            HealthCheck healthCheck = (HealthCheck)obj;
            result = this.checks.remove(healthCheck);
            if (result) {
                LOG.debug("HealthCheck with id {} successfully un-registered", (Object)healthCheck.getId());
            }
        } else {
            HealthCheckRepository repository = (HealthCheckRepository)obj;
            result = this.repositories.remove(repository);
            if (result) {
                LOG.debug("HealthCheckRepository with id {} successfully un-registered", (Object)repository.getId());
            }
        }
        if (result) {
            ServiceHelper.stopService(obj);
        }
        return result;
    }

    @Override
    public Optional<HealthCheckRepository> getRepository(String id) {
        return this.repositories.stream().filter(r -> ObjectHelper.equal(r.getId(), id) || ObjectHelper.equal(r.getId().replace("-health-check-repository", ""), id)).findFirst();
    }

    @Override
    public Stream<HealthCheck> stream() {
        if (this.enabled) {
            return Stream.concat(this.checks.stream(), this.repositories.stream().flatMap(HasHealthChecks::stream)).distinct();
        }
        return Stream.empty();
    }

    @Override
    public void loadHealthChecks() {
        StopWatch watch = new StopWatch();
        if (!this.loadHealthChecksDone) {
            this.loadHealthChecksDone = true;
            DefaultHealthChecksLoader loader = new DefaultHealthChecksLoader(this.camelContext);
            Collection<HealthCheck> col = loader.loadHealthChecks();
            col.forEach(this::register);
            if (!col.isEmpty()) {
                String time = TimeUtils.printDuration(watch.taken(), true);
                LOG.debug("Health checks (scanned: {}) loaded in {}", (Object)col.size(), (Object)time);
            }
        }
    }

    @Override
    public boolean isExcluded(HealthCheck healthCheck) {
        if (this.excludePattern != null) {
            String[] s = this.excludePattern.split(",");
            String id = healthCheck.getId();
            if (PatternHelper.matchPatterns(id, s)) {
                return true;
            }
            if (id.startsWith("route:")) {
                id = id.substring(6);
                return PatternHelper.matchPatterns(id, s);
            }
            if (id.startsWith("consumer:")) {
                id = id.substring(9);
                return PatternHelper.matchPatterns(id, s);
            }
            if (id.startsWith("producer:")) {
                id = id.substring(9);
                return PatternHelper.matchPatterns(id, s);
            }
        }
        return false;
    }

    private void checkIfAccepted(Object obj) {
        boolean accept;
        boolean bl = accept = obj instanceof HealthCheck || obj instanceof HealthCheckRepository;
        if (!accept) {
            throw new IllegalArgumentException();
        }
    }
}

