/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.nio.charset.StandardCharsets;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.processor.transformer.TypeConverterTransformer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="text-plain")
public class StringDataTypeTransformer
extends Transformer {
    private static final Transformer DELEGATE = new TypeConverterTransformer(String.class);

    @Override
    public void transform(Message message, DataType from, DataType to) throws Exception {
        message.getExchange().setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)StandardCharsets.UTF_8.name());
        DELEGATE.transform(message, from, to);
        message.setHeader("Content-Type", "text/plain");
    }
}

