/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.Pluralize;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface HasMetadata
extends KubernetesResource {
    public static final String DNS_LABEL_START = "(?!-)[A-Za-z0-9-]{";
    public static final String DNS_LABEL_END = ",63}(?<!-)";
    public static final String DNS_LABEL_REGEXP = "(?!-)[A-Za-z0-9-]{1,63}(?<!-)";
    public static final Pattern FINALIZER_NAME_MATCHER = Pattern.compile("^(((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+(?!-)[A-Za-z0-9-]{2,63}(?<!-))/(?!-)[A-Za-z0-9-]{1,63}(?<!-)");
    public static final String REQUIRES_NON_NULL_METADATA = "requires non-null metadata";
    public static final String REQUIRES_NON_NULL_NAME = "requires non-null name";
    public static final String REQUIRES_NON_NULL_NAMESPACE = "requires non-null namespace";

    public static String getKind(Class<?> clazz) {
        Kind kind = clazz.getAnnotation(Kind.class);
        return kind != null ? kind.value() : clazz.getSimpleName();
    }

    public static String getApiVersion(Class<?> clazz) {
        String group = HasMetadata.getGroup(clazz);
        String version = HasMetadata.getVersion(clazz);
        if (group != null && version != null) {
            return group + "/" + version;
        }
        if (group != null || version != null) {
            throw new IllegalArgumentException("You need to specify both @" + Group.class.getSimpleName() + " and @" + Version.class.getSimpleName() + " annotations if you specify either");
        }
        return null;
    }

    public static String getGroup(Class<?> clazz) {
        Group group = clazz.getAnnotation(Group.class);
        return group != null ? group.value() : null;
    }

    public static String getVersion(Class<?> clazz) {
        Version version = clazz.getAnnotation(Version.class);
        return version != null ? version.value() : null;
    }

    public static String getPlural(Class<?> clazz) {
        Plural fromAnnotation = clazz.getAnnotation(Plural.class);
        return fromAnnotation != null ? fromAnnotation.value().toLowerCase(Locale.ROOT) : Pluralize.toPlural(HasMetadata.getSingular(clazz));
    }

    public static String getSingular(Class<?> clazz) {
        Singular fromAnnotation = clazz.getAnnotation(Singular.class);
        return (fromAnnotation != null ? fromAnnotation.value() : HasMetadata.getKind(clazz)).toLowerCase(Locale.ROOT);
    }

    public static String getFullResourceName(Class<?> clazz) {
        String plural = HasMetadata.getPlural(clazz);
        String group = HasMetadata.getGroup(clazz);
        if (group == null) {
            throw new IllegalArgumentException("Should provide non-null group. Is " + clazz.getName() + " properly annotated with @" + Group.class.getSimpleName() + " and/or @" + Version.class.getSimpleName() + "?");
        }
        return HasMetadata.getFullResourceName(plural, group);
    }

    public static String getFullResourceName(String plural, String group) {
        Objects.requireNonNull(plural);
        Objects.requireNonNull(group);
        return group.isEmpty() ? plural : plural + "." + group;
    }

    public static boolean validateFinalizer(String finalizer) {
        if (finalizer == null) {
            return false;
        }
        Matcher matcher = FINALIZER_NAME_MATCHER.matcher(finalizer);
        if (matcher.matches()) {
            String group = matcher.group(1);
            return group.length() < 256;
        }
        return false;
    }

    public static OwnerReference sanitizeAndValidate(OwnerReference ownerReference) {
        StringBuilder error = new StringBuilder(100);
        error.append("Owner is missing required field(s): ");
        BiFunction<String, String, Optional> trimmedFieldIfValid = (field, value) -> {
            boolean isError = false;
            if (value == null) {
                isError = true;
            } else if ((value = value.trim()).isEmpty()) {
                isError = true;
            }
            if (isError) {
                error.append((String)field).append(" ");
                return Optional.empty();
            }
            return Optional.of(value);
        };
        Supplier<IllegalArgumentException> exceptionSupplier = () -> new IllegalArgumentException(error.toString());
        Optional uid = trimmedFieldIfValid.apply("uid", ownerReference.getUid());
        Optional apiVersion = trimmedFieldIfValid.apply("apiVersion", ownerReference.getApiVersion());
        Optional name = trimmedFieldIfValid.apply("name", ownerReference.getName());
        Optional kind = trimmedFieldIfValid.apply("kind", ownerReference.getKind());
        ownerReference = ((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder(ownerReference).withUid((String)uid.orElseThrow(exceptionSupplier))).withApiVersion((String)apiVersion.orElseThrow(exceptionSupplier))).withName((String)name.orElseThrow(exceptionSupplier))).withKind((String)kind.orElseThrow(exceptionSupplier))).build();
        return ownerReference;
    }

    public ObjectMeta getMetadata();

    public void setMetadata(ObjectMeta var1);

    default public String getKind() {
        return HasMetadata.getKind(this.getClass());
    }

    default public String getApiVersion() {
        return HasMetadata.getApiVersion(this.getClass());
    }

    public void setApiVersion(String var1);

    @JsonIgnore
    default public String getPlural() {
        return HasMetadata.getPlural(this.getClass());
    }

    @JsonIgnore
    default public String getSingular() {
        return HasMetadata.getSingular(this.getClass());
    }

    @JsonIgnore
    default public String getFullResourceName() {
        return HasMetadata.getFullResourceName(this.getClass());
    }

    @JsonIgnore
    default public boolean isMarkedForDeletion() {
        String deletionTimestamp = this.optionalMetadata().map(ObjectMeta::getDeletionTimestamp).orElse(null);
        return deletionTimestamp != null && !deletionTimestamp.isEmpty();
    }

    default public boolean hasFinalizer(String finalizer) {
        return this.getFinalizers().contains(finalizer);
    }

    @JsonIgnore
    default public List<String> getFinalizers() {
        return this.optionalMetadata().map(ObjectMeta::getFinalizers).orElse(Collections.emptyList());
    }

    default public boolean addFinalizer(String finalizer) {
        if (finalizer == null || finalizer.trim().isEmpty()) {
            throw new IllegalArgumentException("Must pass a non-null, non-blank finalizer.");
        }
        if (this.isMarkedForDeletion() || this.hasFinalizer(finalizer)) {
            return false;
        }
        if (this.isFinalizerValid(finalizer)) {
            ObjectMeta metadata = this.getMetadata();
            if (metadata == null) {
                metadata = new ObjectMeta();
                this.setMetadata(metadata);
            }
            return metadata.getFinalizers().add(finalizer);
        }
        throw new IllegalArgumentException("Invalid finalizer name: '" + finalizer + "'. Must consist of a domain name, a forward slash and the valid kubernetes name.");
    }

    default public boolean isFinalizerValid(String finalizer) {
        return HasMetadata.validateFinalizer(finalizer);
    }

    default public boolean removeFinalizer(String finalizer) {
        List<String> finalizers = this.getFinalizers();
        return finalizers.contains(finalizer) && finalizers.remove(finalizer);
    }

    default public boolean hasOwnerReferenceFor(HasMetadata owner) {
        return this.getOwnerReferenceFor(owner).isPresent();
    }

    default public boolean hasOwnerReferenceFor(String ownerUid) {
        return this.getOwnerReferenceFor(ownerUid).isPresent();
    }

    default public Optional<OwnerReference> getOwnerReferenceFor(HasMetadata owner) {
        if (owner == null) {
            return Optional.empty();
        }
        String ownerUID = owner.optionalMetadata().map(ObjectMeta::getUid).orElse(null);
        return this.getOwnerReferenceFor(ownerUID);
    }

    default public Optional<OwnerReference> getOwnerReferenceFor(String ownerUid) {
        if (ownerUid == null || ownerUid.isEmpty()) {
            return Optional.empty();
        }
        return this.optionalMetadata().map(m -> Optional.ofNullable(m.getOwnerReferences()).orElse(Collections.emptyList())).orElse(Collections.emptyList()).stream().filter(o -> ownerUid.equals(o.getUid())).findFirst();
    }

    default public OwnerReference addOwnerReference(HasMetadata owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Cannot add a reference to a null owner to " + this.optionalMetadata().map(m -> "'" + m.getName() + "' ").orElse("unnamed ") + this.getKind());
        }
        ObjectMeta metadata = owner.getMetadata();
        if (metadata == null) {
            throw new IllegalArgumentException("Cannot add a reference to an owner without metadata to " + this.optionalMetadata().map(m -> "'" + m.getName() + "' ").orElse("unnamed ") + this.getKind());
        }
        if (!(owner instanceof GenericKubernetesResource) && !(this instanceof GenericKubernetesResource) && owner instanceof Namespaced) {
            if (!(this instanceof Namespaced)) {
                throw new IllegalArgumentException("Cannot add owner reference from a cluster scoped to a namespace scoped resource: " + this.optionalMetadata().map(m -> "'" + m.getName() + "' ").orElse("unnamed ") + this.getKind());
            }
            if (this.optionalMetadata().map(m -> !Objects.equals(m.getNamespace(), owner.getMetadata().getNamespace())).orElse(false).booleanValue()) {
                throw new IllegalArgumentException("Cannot add owner reference between two resources in different namespaces:" + this.optionalMetadata().map(m -> "'" + m.getName() + "' ").orElse("unnamed ") + this.getKind());
            }
        }
        OwnerReference ownerReference = ((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withUid(metadata.getUid())).withApiVersion(owner.getApiVersion())).withName(metadata.getName())).withKind(owner.getKind())).build();
        return this.addOwnerReference(HasMetadata.sanitizeAndValidate(ownerReference));
    }

    default public OwnerReference addOwnerReference(OwnerReference ownerReference) {
        List<OwnerReference> ownerReferences;
        if (ownerReference == null) {
            throw new IllegalArgumentException("Cannot add a null reference to " + this.optionalMetadata().map(m -> "'" + m.getName() + "' ").orElse("unnamed ") + this.getKind());
        }
        Optional<OwnerReference> existing = this.getOwnerReferenceFor(ownerReference.getUid());
        if (existing.isPresent()) {
            return existing.get();
        }
        ObjectMeta metadata = this.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            this.setMetadata(metadata);
        }
        if ((ownerReferences = metadata.getOwnerReferences()) == null) {
            ownerReferences = new ArrayList<OwnerReference>();
            metadata.setOwnerReferences(ownerReferences);
        }
        ownerReferences.add(ownerReference);
        return ownerReference;
    }

    default public void removeOwnerReference(String ownerUid) {
        if (ownerUid != null && !ownerUid.isEmpty()) {
            this.optionalMetadata().map(m -> Optional.ofNullable(m.getOwnerReferences()).orElse(Collections.emptyList())).orElse(Collections.emptyList()).removeIf(o -> ownerUid.equals(o.getUid()));
        }
    }

    default public void removeOwnerReference(HasMetadata owner) {
        if (owner != null) {
            this.removeOwnerReference(owner.getMetadata().getUid());
        }
    }

    default public Optional<ObjectMeta> optionalMetadata() {
        return Optional.ofNullable(this.getMetadata());
    }

    default public void initNameAndNamespaceFrom(HasMetadata original) {
        Objects.requireNonNull(original);
        ObjectMeta meta = HasMetadata.initMetadataBuilderNameAndNamespaceFrom(original).build();
        this.setMetadata(meta);
    }

    public static ObjectMetaBuilder initMetadataBuilderNameAndNamespaceFrom(HasMetadata original) {
        Objects.requireNonNull(original);
        ObjectMeta metadata = Objects.requireNonNull(original.getMetadata(), REQUIRES_NON_NULL_METADATA);
        ObjectMetaBuilder metaBuilder = new ObjectMetaBuilder();
        metaBuilder.withName(Objects.requireNonNull(metadata.getName(), REQUIRES_NON_NULL_NAME));
        if (original instanceof Namespaced) {
            metaBuilder.withNamespace(Objects.requireNonNull(metadata.getNamespace(), REQUIRES_NON_NULL_NAMESPACE));
        }
        return metaBuilder;
    }
}

