/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.internal.SerialExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwarderWebsocketListener
implements WebSocket.Listener {
    private static final Logger logger = LoggerFactory.getLogger(PortForwarderWebsocketListener.class);
    private static final String LOG_PREFIX = "FWD";
    private static final String PROTOCOL_ERROR = "Protocol error";
    private static final int BUFFER_SIZE = 4096;
    private final ExecutorService pumperService = Executors.newSingleThreadExecutor();
    private final SerialExecutor serialExecutor;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    final Collection<Throwable> clientThrowables = new CopyOnWriteArrayList<Throwable>();
    final Collection<Throwable> serverThrowables = new CopyOnWriteArrayList<Throwable>();
    private final ReadableByteChannel in;
    private final WritableByteChannel out;
    private int messagesRead = 0;

    public PortForwarderWebsocketListener(ReadableByteChannel in, WritableByteChannel out, Executor executor) {
        this.in = in;
        this.out = out;
        this.serialExecutor = new SerialExecutor(executor);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        logger.debug("{}: onOpen", (Object)LOG_PREFIX);
        if (this.in != null) {
            this.pumperService.execute(() -> {
                try {
                    PortForwarderWebsocketListener.pipe(this.in, webSocket, this.alive::get);
                }
                catch (IOException | InterruptedException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.clientError(webSocket, "writing client data", e);
                }
            });
        }
    }

    private void clientError(WebSocket webSocket, String operation, Exception e) {
        if (this.alive.get()) {
            logger.debug("Error while " + operation, (Throwable)e);
            this.clientThrowables.add(e);
            this.closeBothWays(webSocket, 1001, "Client error");
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, String text) {
        logger.debug("{}: onMessage(String)", (Object)LOG_PREFIX);
        this.onMessage(webSocket, ByteBuffer.wrap(text.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteBuffer buffer) {
        ++this.messagesRead;
        if (this.messagesRead <= 2) {
            webSocket.request();
            return;
        }
        if (!buffer.hasRemaining()) {
            KubernetesClientException e = new KubernetesClientException("Received an empty message");
            this.serverThrowables.add(e);
            logger.debug(PROTOCOL_ERROR, (Throwable)e);
            this.closeBothWays(webSocket, 1002, PROTOCOL_ERROR);
            return;
        }
        byte channel = buffer.get();
        if (channel < 0 || channel > 1) {
            KubernetesClientException e = new KubernetesClientException(String.format("Received a wrong channel from the remote socket: %s", channel));
            this.serverThrowables.add(e);
            logger.debug(PROTOCOL_ERROR, (Throwable)e);
            this.closeBothWays(webSocket, 1002, PROTOCOL_ERROR);
        } else if (channel == 1) {
            KubernetesClientException e = new KubernetesClientException(String.format("Received an error from the remote socket %s", ExecWebSocketListener.toString(buffer)));
            this.serverThrowables.add(e);
            logger.debug("Server error", (Throwable)e);
            this.closeForwarder();
        } else if (this.out != null) {
            try {
                this.serialExecutor.execute(() -> {
                    try {
                        while (buffer.hasRemaining()) {
                            int written = this.out.write(buffer);
                            if (written != 0) continue;
                            Thread.sleep(50L);
                        }
                        webSocket.request();
                    }
                    catch (IOException | InterruptedException e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        this.clientError(webSocket, "forwarding data to the client", e);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason) {
        logger.debug("{}: onClose. Code={}, Reason={}", new Object[]{LOG_PREFIX, code, reason});
        if (this.alive.get()) {
            this.closeForwarder();
        }
    }

    @Override
    public void onError(WebSocket webSocket, Throwable t) {
        logger.debug("{}: Throwable received from websocket", (Object)LOG_PREFIX, (Object)t);
        if (this.alive.get()) {
            this.serverThrowables.add(t);
            this.closeForwarder();
        }
    }

    boolean isAlive() {
        return this.alive.get();
    }

    boolean errorOccurred() {
        return !this.clientThrowables.isEmpty() || !this.serverThrowables.isEmpty();
    }

    Collection<Throwable> getClientThrowables() {
        return this.clientThrowables;
    }

    Collection<Throwable> getServerThrowables() {
        return this.serverThrowables;
    }

    void closeBothWays(WebSocket webSocket, int code, String message) {
        logger.debug("{}: Closing with code {} and reason: {}", new Object[]{LOG_PREFIX, code, message});
        this.alive.set(false);
        try {
            webSocket.sendClose(code, message);
        }
        catch (Exception e) {
            this.serverThrowables.add(e);
            logger.debug("Error while closing the websocket", (Throwable)e);
        }
        this.closeForwarder();
    }

    private void closeForwarder() {
        this.serialExecutor.execute(() -> {
            this.alive.set(false);
            if (this.in != null) {
                Utils.closeQuietly(this.in);
            }
            if (this.out != null && this.out != this.in) {
                Utils.closeQuietly(this.out);
            }
            this.pumperService.shutdownNow();
            this.serialExecutor.shutdownNow();
        });
    }

    private static void pipe(ReadableByteChannel in, WebSocket webSocket, BooleanSupplier isAlive) throws IOException, InterruptedException {
        int read;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        do {
            buffer.clear();
            buffer.put((byte)0);
            read = in.read(buffer);
            if (read > 0) {
                buffer.flip();
                webSocket.send(buffer);
                continue;
            }
            if (read != 0) continue;
            Thread.sleep(50L);
        } while (isAlive.getAsBoolean() && read >= 0);
    }
}

