/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cronjob;

import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobList;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpec;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCronJobProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCronJobProducer.class);

    public KubernetesCronJobProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty(this.getEndpoint().getKubernetesConfiguration().getOperation()) ? exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listCronJob": {
                this.doList(exchange);
                break;
            }
            case "listCronJobByLabels": {
                this.doListCronJobByLabel(exchange);
                break;
            }
            case "getCronJob": {
                this.doGetCronJob(exchange);
                break;
            }
            case "createCronJob": {
                this.doCreateCronJob(exchange);
                break;
            }
            case "updateCronJob": {
                this.doUpdateCronJob(exchange);
                break;
            }
            case "deleteCronJob": {
                this.doDeleteCronJob(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        CronJobList cronJobList = (CronJobList)this.getEndpoint().getKubernetesClient().batch().v1().cronjobs().list();
        KubernetesHelper.prepareOutboundMessage(exchange, cronJobList.getItems());
    }

    protected void doListCronJobByLabel(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesCronJobLabels", Map.class);
        if (ObjectHelper.isEmpty(labels)) {
            throw new IllegalArgumentException("Cron Job by labels require specify a labels set");
        }
        MixedOperation<CronJob, CronJobList, Resource<CronJob>> cronJobs = this.getEndpoint().getKubernetesClient().batch().v1().cronjobs();
        CronJobList jobList = (CronJobList)((FilterWatchListDeletable)cronJobs.withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, jobList.getItems());
    }

    protected void doGetCronJob(Exchange exchange) {
        String cronjobName = exchange.getIn().getHeader("CamelKubernetesCronJobName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(cronjobName)) {
            throw new IllegalArgumentException("Get a specific cronjob require specify a cronnjob name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            throw new IllegalArgumentException("Get a specific cronjob require specify a namespace name");
        }
        CronJob cronJob = (CronJob)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().v1().cronjobs().inNamespace(namespaceName)).withName(cronjobName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, cronJob);
    }

    protected void doUpdateCronJob(Exchange exchange) {
        this.doCreateOrUpdateCronJob(exchange, "Update", Updatable::update);
    }

    protected void doCreateCronJob(Exchange exchange) {
        this.doCreateOrUpdateCronJob(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateCronJob(Exchange exchange, String operationName, Function<Resource<CronJob>, Object> operation) {
        String cronjobName = exchange.getIn().getHeader("CamelKubernetesCronJobName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        CronJobSpec cronjobSpec = exchange.getIn().getHeader("CamelKubernetesCronJobSpec", CronJobSpec.class);
        if (ObjectHelper.isEmpty(cronjobName)) {
            throw new IllegalArgumentException(String.format("%s a specific cronjob require specify a cronjob name", operationName));
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            throw new IllegalArgumentException(String.format("%s a specific cronjob require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty(cronjobSpec)) {
            throw new IllegalArgumentException(String.format("%s a specific cronjob require specify a cronjob spec bean", operationName));
        }
        Map labels = exchange.getIn().getHeader("CamelKubernetesCronJobLabels", Map.class);
        CronJob cronjobCreating = ((CronJobBuilder)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(cronjobName)).withLabels(labels)).endMetadata()).withSpec(cronjobSpec)).build();
        Object cronJob = operation.apply((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().v1().cronjobs().inNamespace(namespaceName)).resource(cronjobCreating));
        KubernetesHelper.prepareOutboundMessage(exchange, cronJob);
    }

    protected void doDeleteCronJob(Exchange exchange) {
        String cronjobName = exchange.getIn().getHeader("CamelKubernetesCronJobName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(cronjobName)) {
            throw new IllegalArgumentException("Delete a specific cronjob require specify a cronjob name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            throw new IllegalArgumentException("Delete a specific cronjob require specify a namespace name");
        }
        ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().v1().cronjobs().inNamespace(namespaceName)).withName(cronjobName)).delete();
        MessageHelper.copyHeaders(exchange.getIn(), exchange.getMessage(), true);
    }
}

