/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.deployments;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeploymentsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesDeploymentsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private DeploymentsConsumerTask deploymentsWatcher;

    public KubernetesDeploymentsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.deploymentsWatcher = new DeploymentsConsumerTask();
        this.executor.submit(this.deploymentsWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Deployments Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.deploymentsWatcher, this.deploymentsWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class DeploymentsConsumerTask
    implements Runnable {
        private Watch watch;

        DeploymentsConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>> w = KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesClient().apps().deployments();
            if (ObjectHelper.isNotEmpty(KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty(KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), w::withName);
            this.watch = w.watch(new Watcher<Deployment>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, Deployment resource) {
                    Exchange exchange = KubernetesDeploymentsConsumer.this.createExchange(false);
                    exchange.getIn().setBody(resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        KubernetesDeploymentsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesDeploymentsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        KubernetesDeploymentsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

