/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class KubernetesHPAEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":masterUrl";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "kubernetes-hpa".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "masterUrl", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(34);
        props.add("apiVersion");
        props.add("bridgeErrorHandler");
        props.add("caCertData");
        props.add("caCertFile");
        props.add("clientCertData");
        props.add("clientCertFile");
        props.add("clientKeyAlgo");
        props.add("clientKeyData");
        props.add("clientKeyFile");
        props.add("clientKeyPassphrase");
        props.add("connectionTimeout");
        props.add("crdGroup");
        props.add("crdName");
        props.add("crdPlural");
        props.add("crdScope");
        props.add("crdVersion");
        props.add("dnsDomain");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("kubernetesClient");
        props.add("labelKey");
        props.add("labelValue");
        props.add("lazyStartProducer");
        props.add("masterUrl");
        props.add("namespace");
        props.add("oauthToken");
        props.add("operation");
        props.add("password");
        props.add("poolSize");
        props.add("portName");
        props.add("portProtocol");
        props.add("resourceName");
        props.add("trustCerts");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(12);
        secretProps.add("caCertData");
        secretProps.add("caCertFile");
        secretProps.add("clientCertData");
        secretProps.add("clientCertFile");
        secretProps.add("clientKeyAlgo");
        secretProps.add("clientKeyData");
        secretProps.add("clientKeyFile");
        secretProps.add("clientKeyPassphrase");
        secretProps.add("oauthToken");
        secretProps.add("password");
        secretProps.add("trustCerts");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

