/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHPAProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHPAProducer.class);

    public KubernetesHPAProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listHPA": {
                this.doList(exchange);
                break;
            }
            case "listHPAByLabels": {
                this.doListHPAByLabel(exchange);
                break;
            }
            case "getHPA": {
                this.doGetHPA(exchange);
                break;
            }
            case "createHPA": {
                this.doCreateHPA(exchange);
                break;
            }
            case "updateHPA": {
                this.doUpdateHPA(exchange);
                break;
            }
            case "deleteHPA": {
                this.doDeleteHPA(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        HorizontalPodAutoscalerList hpaList = (HorizontalPodAutoscalerList)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().list();
        KubernetesHelper.prepareOutboundMessage(exchange, hpaList.getItems());
    }

    protected void doListHPAByLabel(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesHPALabels", Map.class);
        if (ObjectHelper.isEmpty(labels)) {
            LOG.error("Get HPA by labels require specify a labels set");
            throw new IllegalArgumentException("Get HPA by labels require specify a labels set");
        }
        HorizontalPodAutoscalerList hpaList = (HorizontalPodAutoscalerList)((FilterWatchListDeletable)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, hpaList.getItems());
    }

    protected void doGetHPA(Exchange exchange) {
        String podName = exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(podName)) {
            LOG.error("Get a specific hpa require specify an hpa name");
            throw new IllegalArgumentException("Get a specific hpa require specify an hpa name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Get a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Get a specific hpa require specify a namespace name");
        }
        HorizontalPodAutoscaler hpa = (HorizontalPodAutoscaler)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespaceName)).withName(podName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, hpa);
    }

    protected void doUpdateHPA(Exchange exchange) {
        this.doCreateOrUpdateHPA(exchange, "Update", Updatable::update);
    }

    protected void doCreateHPA(Exchange exchange) {
        this.doCreateOrUpdateHPA(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateHPA(Exchange exchange, String operationName, Function<Resource<HorizontalPodAutoscaler>, HorizontalPodAutoscaler> operation) {
        String hpaName = exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        HorizontalPodAutoscalerSpec hpaSpec = exchange.getIn().getHeader("CamelKubernetesHPASpec", HorizontalPodAutoscalerSpec.class);
        if (ObjectHelper.isEmpty(hpaName)) {
            LOG.error("{} a specific hpa require specify a hpa name", (Object)operationName);
            throw new IllegalArgumentException(operationName + " a specific hpa require specify a hpa name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("{} a specific hpa require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(operationName + " a specific hpa require specify a namespace name");
        }
        if (ObjectHelper.isEmpty(hpaSpec)) {
            LOG.error("{} a specific hpa require specify a hpa spec bean", (Object)operationName);
            throw new IllegalArgumentException(operationName + " a specific hpa require specify a hpa spec bean");
        }
        Map labels = exchange.getIn().getHeader("CamelKubernetesHPALabels", Map.class);
        HorizontalPodAutoscaler hpaCreating = ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName(hpaName)).withLabels(labels)).endMetadata()).withSpec(hpaSpec)).build();
        HorizontalPodAutoscaler hpa = operation.apply((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespaceName)).resource(hpaCreating));
        KubernetesHelper.prepareOutboundMessage(exchange, hpa);
    }

    protected void doDeleteHPA(Exchange exchange) {
        String hpaName = exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(hpaName)) {
            LOG.error("Delete a specific hpa require specify a hpa name");
            throw new IllegalArgumentException("Delete a specific hpa require specify a hpa name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Delete a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific hpa require specify a namespace name");
        }
        List<StatusDetails> statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespaceName)).withName(hpaName)).delete();
        boolean hpaDeleted = ObjectHelper.isNotEmpty(statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, hpaDeleted);
    }
}

