/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.secrets.vault;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.kubernetes.properties.SecretPropertiesFunction;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PeriodicTask(value="kubernetes-secret-refresh")
public class SecretsReloadTriggerTask
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private CamelContext camelContext;
    @Metadata(defaultValue="true")
    private boolean reloadEnabled = true;
    private String secrets;
    private KubernetesClient kubernetesClient;
    private SecretPropertiesFunction propertiesFunction;
    private volatile Instant startingTime;
    private static final Logger LOG = LoggerFactory.getLogger(SecretsReloadTriggerTask.class);

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public Instant getStartingTime() {
        return this.startingTime;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        PropertiesComponent pc = this.camelContext.getPropertiesComponent();
        PropertiesFunction pf = pc.getPropertiesFunction("secret");
        if (pf instanceof SecretPropertiesFunction) {
            this.propertiesFunction = (SecretPropertiesFunction)pf;
            LOG.debug("Auto-detecting secrets from properties-function: {}", (Object)pf.getName());
        }
        this.secrets = this.camelContext.getVaultConfiguration().kubernetes().getSecrets();
        if (ObjectHelper.isEmpty(this.secrets) && this.propertiesFunction == null) {
            throw new IllegalArgumentException("Secrets must be configured on Kubernetes vault configuration");
        }
        this.kubernetesClient = this.propertiesFunction.getClient();
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.kubernetesClient != null) {
            try {
                this.kubernetesClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.kubernetesClient = null;
        }
    }

    @Override
    public void run() {
        this.startingTime = Instant.now();
        final CountDownLatch isWatchClosed = new CountDownLatch(1);
        Watch watch = ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(this.kubernetesClient.getNamespace())).watch(new Watcher<Secret>(){

            @Override
            public void eventReceived(Watcher.Action action, Secret secret) {
                switch (action.name()) {
                    case "MODIFIED": {
                        if (!SecretsReloadTriggerTask.this.isReloadEnabled() || !SecretsReloadTriggerTask.this.matchSecret(secret.getMetadata().getName())) break;
                        LOG.info("Update for Kubernetes Secret: {} detected, triggering CamelContext reload", (Object)secret.getMetadata().getName());
                        ContextReloadStrategy reload = SecretsReloadTriggerTask.this.camelContext.hasService(ContextReloadStrategy.class);
                        if (reload == null) break;
                        reload.onReload(this);
                        break;
                    }
                    default: {
                        LOG.debug("Not watched event {}", (Object)action.name());
                    }
                }
            }

            @Override
            public void onClose(WatcherException e) {
                isWatchClosed.countDown();
            }
        });
        try {
            isWatchClosed.await();
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while waiting for the watch to close: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        watch.close();
    }

    protected boolean matchSecret(String name) {
        HashSet set = new HashSet();
        if (this.secrets != null) {
            Collections.addAll(set, this.secrets.split(","));
        }
        for (String part : set) {
            boolean result = name.contains(part) || PatternHelper.matchPattern(name, part);
            LOG.trace("Matching secret id: {}={} -> {}", new Object[]{name, part, result});
            if (!result) continue;
            return true;
        }
        return false;
    }
}

