/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift.builds;

import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftBuildsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftBuildsProducer.class);

    public OpenshiftBuildsProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listBuilds": {
                this.doList(exchange);
                break;
            }
            case "listBuildsByLabels": {
                this.doListBuildByLabels(exchange);
                break;
            }
            case "getBuild": {
                this.doGetBuild(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        BuildList buildList = (BuildList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).builds().inAnyNamespace()).list();
        exchange.getMessage().setBody(buildList.getItems());
    }

    protected void doListBuildByLabels(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesBuildsLabels", Map.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        BuildList buildList = !ObjectHelper.isEmpty(namespaceName) ? (BuildList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).builds().inNamespace(namespaceName)).withLabels(labels)).list() : (BuildList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).builds().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, buildList.getItems());
    }

    protected void doGetBuild(Exchange exchange) {
        String buildName = exchange.getIn().getHeader("CamelKubernetesBuildName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(buildName)) {
            LOG.error("Get a specific Build require specify a Build name");
            throw new IllegalArgumentException("Get a specific Build require specify a Build name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Get a specific Build require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Build require specify a namespace name");
        }
        Build build = (Build)((BuildResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).builds().inNamespace(namespaceName)).withName(buildName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, build);
    }
}

