/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.properties;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.camel.component.kubernetes.properties.BasePropertiesFunction;

abstract class BaseSecretPropertiesFunction
extends BasePropertiesFunction {
    BaseSecretPropertiesFunction() {
    }

    @Override
    Path getMountPath() {
        if (this.getMountPathSecrets() != null) {
            return Paths.get(this.getMountPathSecrets(), new String[0]);
        }
        return null;
    }

    @Override
    String lookup(String name, String key, String defaultValue) {
        String answer = null;
        Secret sec = (Secret)((Resource)this.getClient().secrets().withName(name)).get();
        if (sec != null) {
            String string = answer = sec.getStringData() != null ? sec.getStringData().get(key) : null;
            if (answer == null) {
                byte[] data;
                String string2 = answer = sec.getData() != null ? sec.getData().get(key) : null;
                if (answer != null && (data = Base64.getDecoder().decode(answer)) != null) {
                    answer = this.handleData(key, data);
                }
            }
        }
        if (answer == null) {
            return defaultValue;
        }
        return answer;
    }
}

