/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.secrets.vault;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.kubernetes.properties.SecretPropertiesFunction;
import org.apache.camel.component.kubernetes.secrets.vault.SecretsReloadTriggerTask;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.vault.KubernetesVaultConfiguration;

@DevConsole(name="kubernetes-secrets", displayName="Kubernetes Secrets", description="Kubernetes Cluster Secrets")
public class SecretsDevConsole
extends AbstractDevConsole {
    private SecretPropertiesFunction propertiesFunction;
    private SecretsReloadTriggerTask secretsRefreshTask;

    public SecretsDevConsole() {
        super("camel", "kubernetes-secrets", "Kubernetes Secrets", "Kubernetes Cluster Secrets");
    }

    @Override
    protected void doStart() throws Exception {
        KubernetesVaultConfiguration kubernetes;
        PropertiesFunction pf;
        super.doStart();
        if (this.getCamelContext().getPropertiesComponent().hasPropertiesFunction("secret") && (pf = this.getCamelContext().getPropertiesComponent().getPropertiesFunction("secret")) instanceof SecretPropertiesFunction) {
            this.propertiesFunction = (SecretPropertiesFunction)pf;
        }
        if ((kubernetes = this.getCamelContext().getVaultConfiguration().getKubernetesVaultConfiguration()) != null && kubernetes.isRefreshEnabled()) {
            PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler(this.getCamelContext());
            this.secretsRefreshTask = scheduler.getTaskByType(SecretsReloadTriggerTask.class);
        }
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (this.propertiesFunction != null) {
            sb.append("Kubernetes Secrets Cluster:");
            sb.append(String.format("\n    Master Url: %s", this.propertiesFunction.getClient().getMasterUrl()));
            sb.append("\n    Login: OAuth Token");
            KubernetesVaultConfiguration kubernetes = this.getCamelContext().getVaultConfiguration().getKubernetesVaultConfiguration();
            if (kubernetes != null) {
                sb.append(String.format("\n    Refresh Enabled: %s", kubernetes.isRefreshEnabled()));
            }
            if (this.secretsRefreshTask != null) {
                Instant start = this.secretsRefreshTask.getStartingTime();
                String s = start != null ? TimeUtils.printSince(start.toEpochMilli()) : "none";
                sb.append(String.format("\n    Running Since: %s", s));
            }
            ArrayList<Object> sorted = new ArrayList();
            if (kubernetes != null) {
                sb.append("\n\nSecrets in use:");
                sorted = new ArrayList<String>(List.of(kubernetes.getSecrets().split(",")));
                Collections.sort(sorted);
            }
            for (String sec : sorted) {
                sb.append(String.format("\n    %s", sec));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        Instant start;
        KubernetesVaultConfiguration kubernetes;
        JsonObject root = new JsonObject();
        if (this.propertiesFunction != null) {
            root.put("masterUrl", this.propertiesFunction.getClient().getMasterUrl().toString());
            root.put("login", "OAuth Token");
        }
        if ((kubernetes = this.getCamelContext().getVaultConfiguration().getKubernetesVaultConfiguration()) != null) {
            root.put("refreshEnabled", kubernetes.isRefreshEnabled());
        }
        if (this.secretsRefreshTask != null && (start = this.secretsRefreshTask.getStartingTime()) != null) {
            long timestamp = start.toEpochMilli();
            root.put("startCheckTimestamp", timestamp);
        }
        JsonArray arr = new JsonArray();
        root.put("secrets", arr);
        ArrayList<String> sorted = new ArrayList<String>(List.of(kubernetes.getSecrets().split(",")));
        Collections.sort(sorted);
        for (String sec : sorted) {
            JsonObject jo = new JsonObject();
            jo.put("name", sec);
            arr.add(jo);
        }
        return root;
    }
}

