/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift.deploymentconfigs;

import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.openshift.deploymentconfigs.DeploymentConfigEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftDeploymentConfigsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftDeploymentConfigsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private DeploymentsConfigConsumerTask deploymentsWatcher;

    public OpenshiftDeploymentConfigsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.deploymentsWatcher = new DeploymentsConfigConsumerTask();
        this.executor.submit(this.deploymentsWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Openshift DeploymentConfigs Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.deploymentsWatcher, this.deploymentsWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class DeploymentsConfigConsumerTask
    implements Runnable {
        private Watch watch;

        DeploymentsConfigConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> w = OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs();
            if (ObjectHelper.isNotEmpty(OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty(OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), w::withName);
            this.watch = w.watch(new Watcher<DeploymentConfig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, DeploymentConfig resource) {
                    DeploymentConfigEvent de = new DeploymentConfigEvent(action, resource);
                    Exchange exchange = OpenshiftDeploymentConfigsConsumer.this.createExchange(false);
                    exchange.getIn().setBody(de.getDeploymentConfig());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)de.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        OpenshiftDeploymentConfigsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        OpenshiftDeploymentConfigsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        OpenshiftDeploymentConfigsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

