/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.StringUnionOperations;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicAutomata {
    private BasicAutomata() {
    }

    public static Automaton makeEmpty() {
        State state;
        Automaton automaton = new Automaton();
        automaton.initial = state = new State();
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeEmptyString() {
        Automaton automaton = new Automaton();
        automaton.singleton = "";
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeAnyString() {
        State state;
        Automaton automaton = new Automaton();
        automaton.initial = state = new State();
        state.accept = true;
        state.transitions.add(new Transition('\u0000', '\uffff', state));
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeCharRange('\u0000', '\uffff');
    }

    public static Automaton makeChar(char c) {
        Automaton automaton = new Automaton();
        automaton.singleton = Character.toString(c);
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeCharRange(char c, char c2) {
        if (c == c2) {
            return BasicAutomata.makeChar(c);
        }
        Automaton automaton = new Automaton();
        State state = new State();
        State state2 = new State();
        automaton.initial = state;
        state2.accept = true;
        if (c <= c2) {
            state.transitions.add(new Transition(c, c2, state2));
        }
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeCharSet(String string) {
        if (string.length() == 1) {
            return BasicAutomata.makeChar(string.charAt(0));
        }
        Automaton automaton = new Automaton();
        State state = new State();
        State state2 = new State();
        automaton.initial = state;
        state2.accept = true;
        for (int i = 0; i < string.length(); ++i) {
            state.transitions.add(new Transition(string.charAt(i), state2));
        }
        automaton.deterministic = true;
        automaton.reduce();
        return automaton;
    }

    private static State anyOfRightLength(String string, int n) {
        State state = new State();
        if (string.length() == n) {
            state.setAccept(true);
        } else {
            state.addTransition(new Transition('0', '9', BasicAutomata.anyOfRightLength(string, n + 1)));
        }
        return state;
    }

    private static State atLeast(String string, int n, Collection<State> collection, boolean bl) {
        State state = new State();
        if (string.length() == n) {
            state.setAccept(true);
        } else {
            if (bl) {
                collection.add(state);
            }
            char c = string.charAt(n);
            state.addTransition(new Transition(c, BasicAutomata.atLeast(string, n + 1, collection, bl && c == '0')));
            if (c < '9') {
                state.addTransition(new Transition((char)(c + '\u0001'), '9', BasicAutomata.anyOfRightLength(string, n + 1)));
            }
        }
        return state;
    }

    private static State atMost(String string, int n) {
        State state = new State();
        if (string.length() == n) {
            state.setAccept(true);
        } else {
            char c = string.charAt(n);
            state.addTransition(new Transition(c, BasicAutomata.atMost(string, (char)n + '\u0001')));
            if (c > '0') {
                state.addTransition(new Transition('0', (char)(c - '\u0001'), BasicAutomata.anyOfRightLength(string, n + 1)));
            }
        }
        return state;
    }

    private static State between(String string, String string2, int n, Collection<State> collection, boolean bl) {
        State state = new State();
        if (string.length() == n) {
            state.setAccept(true);
        } else {
            char c;
            char c2;
            if (bl) {
                collection.add(state);
            }
            if ((c2 = string.charAt(n)) == (c = string2.charAt(n))) {
                state.addTransition(new Transition(c2, BasicAutomata.between(string, string2, n + 1, collection, bl && c2 == '0')));
            } else {
                state.addTransition(new Transition(c2, BasicAutomata.atLeast(string, n + 1, collection, bl && c2 == '0')));
                state.addTransition(new Transition(c, BasicAutomata.atMost(string2, n + 1)));
                if (c2 + '\u0001' < c) {
                    state.addTransition(new Transition((char)(c2 + '\u0001'), (char)(c - '\u0001'), BasicAutomata.anyOfRightLength(string, n + 1)));
                }
            }
        }
        return state;
    }

    public static Automaton makeInterval(int n, int n2, int n3) throws IllegalArgumentException {
        Automaton automaton = new Automaton();
        String string = Integer.toString(n);
        String string2 = Integer.toString(n2);
        if (n > n2 || n3 > 0 && string2.length() > n3) {
            throw new IllegalArgumentException();
        }
        int n4 = n3 > 0 ? n3 : string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = string.length(); i < n4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        string = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = string2.length(); i < n4; ++i) {
            stringBuilder2.append('0');
        }
        stringBuilder2.append(string2);
        string2 = stringBuilder2.toString();
        ArrayList<State> arrayList = new ArrayList<State>();
        automaton.initial = BasicAutomata.between(string, string2, 0, arrayList, n3 <= 0);
        if (n3 <= 0) {
            ArrayList<StatePair> arrayList2 = new ArrayList<StatePair>();
            for (State state : arrayList) {
                if (automaton.initial == state) continue;
                arrayList2.add(new StatePair(automaton.initial, state));
            }
            automaton.addEpsilons(arrayList2);
            automaton.initial.addTransition(new Transition('0', automaton.initial));
            automaton.deterministic = false;
        } else {
            automaton.deterministic = true;
        }
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton makeString(String string) {
        Automaton automaton = new Automaton();
        automaton.singleton = string;
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeStringUnion(CharSequence ... charSequenceArray) {
        if (charSequenceArray.length == 0) {
            return BasicAutomata.makeEmpty();
        }
        Arrays.sort(charSequenceArray, StringUnionOperations.LEXICOGRAPHIC_ORDER);
        Automaton automaton = new Automaton();
        automaton.setInitialState(StringUnionOperations.build(charSequenceArray));
        automaton.setDeterministic(true);
        automaton.reduce();
        automaton.recomputeHashCode();
        return automaton;
    }

    public static Automaton makeMaxInteger(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '0'; ++n) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0*(0|");
        if (n < string.length()) {
            stringBuilder.append("[0-9]{1," + (string.length() - n - 1) + "}|");
        }
        BasicAutomata.maxInteger(string.substring(n), 0, stringBuilder);
        stringBuilder.append(")");
        return Automaton.minimize(new RegExp(stringBuilder.toString()).toAutomaton());
    }

    private static void maxInteger(String string, int n, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        if (n < string.length()) {
            char c = string.charAt(n);
            if (c != '0') {
                stringBuilder.append("[0-" + (char)(c - '\u0001') + "][0-9]{" + (string.length() - n - 1) + "}|");
            }
            stringBuilder.append(c);
            BasicAutomata.maxInteger(string, n + 1, stringBuilder);
        }
        stringBuilder.append(')');
    }

    public static Automaton makeMinInteger(String string) {
        int n = 0;
        while (n + 1 < string.length() && string.charAt(n) == '0') {
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0*");
        BasicAutomata.minInteger(string.substring(n), 0, stringBuilder);
        stringBuilder.append("[0-9]*");
        return Automaton.minimize(new RegExp(stringBuilder.toString()).toAutomaton());
    }

    private static void minInteger(String string, int n, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        if (n < string.length()) {
            char c = string.charAt(n);
            if (c != '9') {
                stringBuilder.append("[" + (char)(c + '\u0001') + "-9][0-9]{" + (string.length() - n - 1) + "}|");
            }
            stringBuilder.append(c);
            BasicAutomata.minInteger(string, n + 1, stringBuilder);
        }
        stringBuilder.append(')');
    }

    public static Automaton makeTotalDigits(int n) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?0*([0-9]{0," + n + "}|((([0-9]\\.*){0," + n + "})&@\\.@)0*)[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeFractionDigits(int n) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?[0-9]+(\\.[0-9]{0," + n + "}0*)?[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeIntegerValue(String string) {
        int n;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '-') {
                bl = true;
            }
            if (c >= '1' && c <= '9') break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(n));
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0");
        }
        Automaton automaton = bl ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton automaton2 = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(automaton2.concatenate(automaton.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(stringBuilder.toString()))).concatenate(automaton2));
    }

    public static Automaton makeDecimalValue(String string) {
        int n;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '-') {
                bl = true;
            }
            if (c >= '1' && c <= '9' || c == '.') break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = string.indexOf(46, n);
        if (n2 == -1) {
            stringBuilder.append(string.substring(n));
        } else {
            char c;
            stringBuilder.append(string.substring(n, n2));
            for (n = string.length() - 1; n > n2 && ((c = string.charAt(n)) < '1' || c > '9'); --n) {
            }
            stringBuilder2.append(string.substring(n2 + 1, n + 1));
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0");
        }
        Automaton automaton = bl ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton automaton2 = stringBuilder2.length() == 0 ? Automaton.makeChar('.').concatenate(Automaton.makeChar('0').repeat(1)).optional() : Automaton.makeChar('.').concatenate(Automaton.makeString(stringBuilder2.toString())).concatenate(Automaton.makeChar('0').repeat());
        Automaton automaton3 = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(automaton3.concatenate(automaton.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(stringBuilder.toString())).concatenate(automaton2)).concatenate(automaton3));
    }

    public static Automaton makeStringMatcher(String string) {
        Automaton automaton = new Automaton();
        State[] stateArray = new State[string.length() + 1];
        stateArray[0] = automaton.initial;
        for (int i = 0; i < string.length(); ++i) {
            stateArray[i + 1] = new State();
        }
        State state = stateArray[string.length()];
        state.accept = true;
        state.transitions.add(new Transition('\u0000', '\uffff', state));
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c;
            HashSet<Character> hashSet = new HashSet<Character>();
            char c2 = string.charAt(i);
            stateArray[i].transitions.add(new Transition(c2, stateArray[i + 1]));
            hashSet.add(Character.valueOf(c2));
            for (int j = i; j >= 1; --j) {
                c = string.charAt(j - 1);
                if (hashSet.contains(Character.valueOf(c)) || !string.substring(0, j - 1).equals(string.substring(i - j + 1, i))) continue;
                stateArray[i].transitions.add(new Transition(c, stateArray[j]));
                hashSet.add(Character.valueOf(c));
            }
            char[] cArray = new char[hashSet.size()];
            c = '\u0000';
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                n = ((Character)iterator2.next()).charValue();
                cArray[c++] = n;
            }
            Arrays.sort(cArray);
            int n2 = 0;
            n = 0;
            while (n2 <= 65535) {
                while (n < cArray.length && cArray[n] == n2) {
                    ++n;
                    ++n2;
                }
                if (n2 > 65535) continue;
                int n3 = 65535;
                if (n < cArray.length) {
                    n3 = cArray[n] - '\u0001';
                    ++n;
                }
                stateArray[i].transitions.add(new Transition((char)n2, (char)n3, stateArray[0]));
                n2 = n3 + 2;
            }
        }
        automaton.deterministic = true;
        return automaton;
    }
}

