/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Utils;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AsyncUtils {
    private AsyncUtils() {
    }

    public static <T> CompletableFuture<T> withTimeout(CompletableFuture<T> future, Duration timeout2) {
        if (timeout2 != null && timeout2.toMillis() > 0L) {
            CompletableFuture<Void> scheduled = Utils.schedule(Runnable::run, () -> future.completeExceptionally(new TimeoutException()), timeout2.toMillis(), TimeUnit.MILLISECONDS);
            future.whenComplete((v, t) -> scheduled.cancel(true));
        }
        return future;
    }

    public static <T> CompletableFuture<T> retryWithExponentialBackoff(Supplier<CompletableFuture<T>> action, Consumer<T> onCancel, Duration timeout2, ExponentialBackoffIntervalCalculator retryIntervalCalculator, ShouldRetry<T> shouldRetry) {
        CompletableFuture result = new CompletableFuture();
        AsyncUtils.retryWithExponentialBackoff(result, action, onCancel, timeout2, retryIntervalCalculator, shouldRetry);
        return result;
    }

    private static <T> void retryWithExponentialBackoff(CompletableFuture<T> result, Supplier<CompletableFuture<T>> action, Consumer<T> onCancel, Duration timeout2, ExponentialBackoffIntervalCalculator retryIntervalCalculator, ShouldRetry<T> shouldRetry) {
        AsyncUtils.withTimeout(action.get(), timeout2).whenComplete((r, t) -> {
            long retryInterval;
            if (retryIntervalCalculator.shouldRetry() && !result.isDone() && shouldRetry.shouldRetry((Object)r, (Throwable)t, retryInterval = retryIntervalCalculator.nextReconnectInterval())) {
                if (r != null) {
                    onCancel.accept(r);
                }
                Utils.schedule(Runnable::run, () -> AsyncUtils.lambda$null$2(result, (Supplier)action, onCancel, timeout2, retryIntervalCalculator, shouldRetry), retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else if (!result.complete(r)) {
                onCancel.accept(r);
            }
        });
    }

    private static /* synthetic */ void lambda$null$2(CompletableFuture result, Supplier action, Consumer onCancel, Duration timeout2, ExponentialBackoffIntervalCalculator retryIntervalCalculator, ShouldRetry shouldRetry) {
        AsyncUtils.retryWithExponentialBackoff(result, action, onCancel, timeout2, retryIntervalCalculator, shouldRetry);
    }

    @FunctionalInterface
    public static interface ShouldRetry<T> {
        public boolean shouldRetry(T var1, Throwable var2, long var3);
    }
}

