/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String AUTHORIZATION = "Authorization";
    public static final String NAME = "TOKEN";
    protected final Config config;
    private final Function<Config, CompletableFuture<String>> remoteRefresh;
    private static final int REFRESH_INTERVAL_MINUTE = 1;
    private volatile Instant latestRefreshTimestamp;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory2, Instant latestRefreshTimestamp) {
        this(config, latestRefreshTimestamp, (Config newestConfig) -> OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(config, newestConfig.getAuthProvider().getConfig(), factory2.newBuilder()));
    }

    public TokenRefreshInterceptor(Config config, Instant latestRefreshTimestamp, Function<Config, CompletableFuture<String>> remoteRefresh) {
        this.config = config;
        this.remoteRefresh = remoteRefresh;
        this.latestRefreshTimestamp = latestRefreshTimestamp;
    }

    @Override
    public void before(BasicBuilder headerBuilder, HttpRequest request, Interceptor.RequestTags tags) {
        if (this.useBasicAuth()) {
            headerBuilder.header(AUTHORIZATION, HttpClientUtils.basicCredentials(this.config.getUsername(), this.config.getPassword()));
            return;
        }
        String token = TokenRefreshInterceptor.getEffectiveOauthToken(this.config);
        if (Utils.isNotNullOrEmpty(token)) {
            headerBuilder.header(AUTHORIZATION, "Bearer " + token);
        } else if (this.useRemoteRefresh(this.config)) {
            headerBuilder.header(AUTHORIZATION, "Bearer invalid");
        }
        if (this.isTimeToRefresh()) {
            this.refreshToken(headerBuilder);
        }
    }

    private static String getEffectiveOauthToken(Config config) {
        if (config.getOauthTokenProvider() != null) {
            return config.getOauthTokenProvider().getToken();
        }
        if (config.getOauthToken() != null) {
            return config.getOauthToken();
        }
        return config.getAutoOAuthToken();
    }

    protected boolean useBasicAuth() {
        return this.isBasicAuth();
    }

    protected final boolean isBasicAuth() {
        return Utils.isNotNullOrEmpty(this.config.getUsername()) && Utils.isNotNullOrEmpty(this.config.getPassword());
    }

    private boolean isTimeToRefresh() {
        return this.latestRefreshTimestamp.plus(1L, ChronoUnit.MINUTES).isBefore(Instant.now());
    }

    @Override
    public CompletableFuture<Boolean> afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response, Interceptor.RequestTags tags) {
        if (this.shouldFail(response)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.refreshToken(headerBuilder);
    }

    protected boolean shouldFail(HttpResponse<?> response) {
        return this.useBasicAuth() || response.code() != 401;
    }

    private CompletableFuture<Boolean> refreshToken(BasicBuilder headerBuilder) {
        if (this.config.getOauthTokenProvider() != null) {
            String tokenFromProvider = this.config.getOauthTokenProvider().getToken();
            return CompletableFuture.completedFuture(this.overrideNewAccessTokenToConfig(tokenFromProvider, headerBuilder));
        }
        if (this.config.getOauthToken() != null) {
            return CompletableFuture.completedFuture(false);
        }
        Config newestConfig = this.config.refresh();
        CompletableFuture<String> newAccessToken = this.extractNewAccessTokenFrom(newestConfig);
        return newAccessToken.thenApply(token -> this.overrideNewAccessTokenToConfig((String)token, headerBuilder));
    }

    private CompletableFuture<String> extractNewAccessTokenFrom(Config newestConfig) {
        if (this.useRemoteRefresh(newestConfig)) {
            return this.remoteRefresh.apply(newestConfig);
        }
        return CompletableFuture.completedFuture(TokenRefreshInterceptor.getEffectiveOauthToken(newestConfig));
    }

    protected boolean useRemoteRefresh(Config newestConfig) {
        return TokenRefreshInterceptor.isAuthProviderOidc(newestConfig) && OpenIDConnectionUtils.idTokenExpired(newestConfig);
    }

    private boolean overrideNewAccessTokenToConfig(String newAccessToken, BasicBuilder headerBuilder) {
        if (Utils.isNotNullOrEmpty(newAccessToken)) {
            headerBuilder.setHeader(AUTHORIZATION, "Bearer " + newAccessToken);
            this.config.setAutoOAuthToken(newAccessToken);
            this.updateLatestRefreshTimestamp();
            return true;
        }
        return false;
    }

    private void updateLatestRefreshTimestamp() {
        this.latestRefreshTimestamp = Instant.now();
    }

    private static boolean isAuthProviderOidc(Config newestConfig) {
        return newestConfig.getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc");
    }
}

