/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cloud;

import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cloud.KubernetesServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;

public class KubernetesEnvServiceDiscovery
extends KubernetesServiceDiscovery {
    public KubernetesEnvServiceDiscovery(KubernetesConfiguration configuration) {
        super(configuration);
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        try {
            CamelContext ctx = this.getCamelContext();
            String host = ctx.resolvePropertyPlaceholders("{{service.host:" + name + "}}");
            String num = ctx.resolvePropertyPlaceholders("{{service.port:" + name + "}}");
            int port = ctx.getTypeConverter().tryConvertTo(Integer.TYPE, num);
            return Collections.singletonList(new DefaultServiceDefinition(name, host, port));
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public String toString() {
        return "KubernetesEnvServiceDiscovery";
    }
}

