/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster.lock;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.kubernetes.cluster.LeaseResourceType;

public class KubernetesLockConfiguration
implements Cloneable {
    public static final LeaseResourceType DEFAULT_LEASE_RESOURCE_TYPE = LeaseResourceType.Lease;
    public static final String DEFAULT_RESOURCE_NAME = "leaders";
    public static final double DEFAULT_JITTER_FACTOR = 1.2;
    public static final long DEFAULT_LEASE_DURATION_MILLIS = 15000L;
    public static final long DEFAULT_RENEW_DEADLINE_MILLIS = 10000L;
    public static final long DEFAULT_RETRY_PERIOD_MILLIS = 2000L;
    private LeaseResourceType leaseResourceType = DEFAULT_LEASE_RESOURCE_TYPE;
    private String kubernetesResourcesNamespace;
    private String kubernetesResourceName = "leaders";
    private String groupName;
    private String podName;
    private Map<String, String> clusterLabels = new HashMap<String, String>();
    private double jitterFactor = 1.2;
    private long leaseDurationMillis = 15000L;
    private long renewDeadlineMillis = 10000L;
    private long retryPeriodMillis = 2000L;

    public LeaseResourceType getLeaseResourceType() {
        return this.leaseResourceType;
    }

    public void setLeaseResourceType(LeaseResourceType leaseResourceType) {
        this.leaseResourceType = leaseResourceType;
    }

    public String getKubernetesResourcesNamespaceOrDefault(KubernetesClient kubernetesClient) {
        if (this.kubernetesResourcesNamespace != null) {
            return this.kubernetesResourcesNamespace;
        }
        return kubernetesClient.getNamespace();
    }

    public String getKubernetesResourcesNamespace() {
        return this.kubernetesResourcesNamespace;
    }

    public void setKubernetesResourcesNamespace(String kubernetesResourcesNamespace) {
        this.kubernetesResourcesNamespace = kubernetesResourcesNamespace;
    }

    @Deprecated
    public String getConfigMapName() {
        return this.kubernetesResourceName;
    }

    @Deprecated
    public void setConfigMapName(String kubernetesResourceName) {
        this.kubernetesResourceName = kubernetesResourceName;
    }

    public String getKubernetesResourceName() {
        return this.kubernetesResourceName;
    }

    public void setKubernetesResourceName(String kubernetesResourceName) {
        this.kubernetesResourceName = kubernetesResourceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getPodName() {
        return this.podName;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public Map<String, String> getClusterLabels() {
        return this.clusterLabels;
    }

    public void addToClusterLabels(String key, String value) {
        this.clusterLabels.put(key, value);
    }

    public void setClusterLabels(Map<String, String> clusterLabels) {
        this.clusterLabels = clusterLabels;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public void setJitterFactor(double jitterFactor) {
        this.jitterFactor = jitterFactor;
    }

    public int getLeaseDurationSeconds() {
        return (int)(this.getLeaseDurationMillis() / 1000L);
    }

    public long getLeaseDurationMillis() {
        return this.leaseDurationMillis;
    }

    public void setLeaseDurationMillis(long leaseDurationMillis) {
        this.leaseDurationMillis = leaseDurationMillis;
    }

    public int getRenewDeadlineSeconds() {
        return (int)(this.getRenewDeadlineMillis() / 1000L);
    }

    public long getRenewDeadlineMillis() {
        return this.renewDeadlineMillis;
    }

    public void setRenewDeadlineMillis(long renewDeadlineMillis) {
        this.renewDeadlineMillis = renewDeadlineMillis;
    }

    public long getRetryPeriodMillis() {
        return this.retryPeriodMillis;
    }

    public void setRetryPeriodMillis(long retryPeriodMillis) {
        this.retryPeriodMillis = retryPeriodMillis;
    }

    public KubernetesLockConfiguration copy() {
        try {
            return (KubernetesLockConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Cannot clone", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KubernetesLockConfiguration{");
        sb.append("kubernetesResourcesNamespace='").append(this.kubernetesResourcesNamespace).append('\'');
        sb.append(", kubernetesResourceName='").append(this.kubernetesResourceName).append('\'');
        sb.append(", groupName='").append(this.groupName).append('\'');
        sb.append(", podName='").append(this.podName).append('\'');
        sb.append(", clusterLabels=").append(this.clusterLabels);
        sb.append(", jitterFactor=").append(this.jitterFactor);
        sb.append(", leaseDurationMillis=").append(this.leaseDurationMillis);
        sb.append(", renewDeadlineMillis=").append(this.renewDeadlineMillis);
        sb.append(", retryPeriodMillis=").append(this.retryPeriodMillis);
        sb.append('}');
        return sb.toString();
    }
}

