/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.nodes;

import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesNodesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesNodesProducer.class);

    public KubernetesNodesProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listNodes": {
                this.doList(exchange);
                break;
            }
            case "listNodesByLabels": {
                this.doListNodesByLabels(exchange);
                break;
            }
            case "getNode": {
                this.doGetNode(exchange);
                break;
            }
            case "createNode": {
                this.doCreateNode(exchange);
                break;
            }
            case "updateNode": {
                this.doUpdateNode(exchange);
                break;
            }
            case "deleteNode": {
                this.doDeleteNode(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        NodeList nodeList = (NodeList)this.getEndpoint().getKubernetesClient().nodes().list();
        KubernetesHelper.prepareOutboundMessage(exchange, nodeList.getItems());
    }

    protected void doListNodesByLabels(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesNodesLabels", Map.class);
        NodeList nodeList = (NodeList)((FilterWatchListDeletable)this.getEndpoint().getKubernetesClient().nodes().withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, nodeList.getItems());
    }

    protected void doGetNode(Exchange exchange) {
        String pvName = exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        if (ObjectHelper.isEmpty(pvName)) {
            LOG.error("Get a specific Node require specify a Node name");
            throw new IllegalArgumentException("Get a specific Node require specify a Node name");
        }
        Node node = (Node)((Resource)this.getEndpoint().getKubernetesClient().nodes().withName(pvName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, node);
    }

    protected void doUpdateNode(Exchange exchange) {
        this.doCreateOrUpdateNode(exchange, "Update", Updatable::update);
    }

    protected void doCreateNode(Exchange exchange) {
        this.doCreateOrUpdateNode(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateNode(Exchange exchange, String operationName, Function<Resource<Node>, Node> operation) {
        String nodeName = exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        NodeSpec nodeSpec = exchange.getIn().getHeader("CamelKubernetesNodeSpec", NodeSpec.class);
        if (ObjectHelper.isEmpty(nodeName)) {
            LOG.error("{} a specific node require specify a node name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific node require specify a node name", operationName));
        }
        if (ObjectHelper.isEmpty(nodeSpec)) {
            LOG.error("{} a specific node require specify a node spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific node require specify a node spec bean", operationName));
        }
        Map labels = exchange.getIn().getHeader("CamelKubernetesPodsLabels", Map.class);
        Node nodeCreating = ((NodeBuilder)((NodeBuilder)((NodeFluent.MetadataNested)((NodeFluent.MetadataNested)new NodeBuilder().withNewMetadata().withName(nodeName)).withLabels(labels)).endMetadata()).withSpec(nodeSpec)).build();
        Node node = operation.apply((Resource)this.getEndpoint().getKubernetesClient().nodes().resource(nodeCreating));
        KubernetesHelper.prepareOutboundMessage(exchange, node);
    }

    protected void doDeleteNode(Exchange exchange) {
        String nodeName = exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        if (ObjectHelper.isEmpty(nodeName)) {
            LOG.error("Deleting a specific Node require specify a Node name");
            throw new IllegalArgumentException("Deleting a specific Node require specify a Node name");
        }
        List<StatusDetails> statusDetails = ((Resource)this.getEndpoint().getKubernetesClient().nodes().withName(nodeName)).delete();
        boolean nodeDeleted = ObjectHelper.isNotEmpty(statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, nodeDeleted);
    }
}

