/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.pods;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPodsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPodsProducer.class);

    public KubernetesPodsProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listPods": {
                this.doList(exchange);
                break;
            }
            case "listPodsByLabels": {
                this.doListPodsByLabel(exchange);
                break;
            }
            case "getPod": {
                this.doGetPod(exchange);
                break;
            }
            case "createPod": {
                this.doCreatePod(exchange);
                break;
            }
            case "updatePod": {
                this.doUpdatePod(exchange);
                break;
            }
            case "deletePod": {
                this.doDeletePod(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        PodList podList = ObjectHelper.isNotEmpty(namespaceName) ? (PodList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).list() : (PodList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, podList.getItems());
    }

    protected void doListPodsByLabel(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesPodsLabels", Map.class);
        if (ObjectHelper.isEmpty(labels)) {
            LOG.error("Get pods by labels require specify a labels set");
            throw new IllegalArgumentException("Get pods by labels require specify a labels set");
        }
        PodList podList = (PodList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, podList.getItems());
    }

    protected void doGetPod(Exchange exchange) {
        String podName = exchange.getIn().getHeader("CamelKubernetesPodName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(podName)) {
            LOG.error("Get a specific pod require specify a pod name");
            throw new IllegalArgumentException("Get a specific pod require specify a pod name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Get a specific pod require specify a namespace name");
            throw new IllegalArgumentException("Get a specific pod require specify a namespace name");
        }
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).withName(podName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, pod);
    }

    protected void doUpdatePod(Exchange exchange) {
        this.doCreateOrUpdatePod(exchange, "Update", Updatable::update);
    }

    protected void doCreatePod(Exchange exchange) {
        this.doCreateOrUpdatePod(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdatePod(Exchange exchange, String operationName, Function<Resource<Pod>, Pod> operation) {
        String podName = exchange.getIn().getHeader("CamelKubernetesPodName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        PodSpec podSpec = exchange.getIn().getHeader("CamelKubernetesPodSpec", PodSpec.class);
        if (ObjectHelper.isEmpty(podName)) {
            LOG.error("{} a specific pod require specify a pod name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific pod require specify a pod name", operationName));
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("{} a specific pod require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific pod require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty(podSpec)) {
            LOG.error("{} a specific pod require specify a pod spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific pod require specify a pod spec bean", operationName));
        }
        Map labels = exchange.getIn().getHeader("CamelKubernetesPodsLabels", Map.class);
        Pod podCreating = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(podName)).withLabels(labels)).endMetadata()).withSpec(podSpec)).build();
        Pod pod = operation.apply((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).resource(podCreating));
        KubernetesHelper.prepareOutboundMessage(exchange, pod);
    }

    protected void doDeletePod(Exchange exchange) {
        String podName = exchange.getIn().getHeader("CamelKubernetesPodName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(podName)) {
            LOG.error("Delete a specific pod require specify a pod name");
            throw new IllegalArgumentException("Delete a specific pod require specify a pod name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Delete a specific pod require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific pod require specify a namespace name");
        }
        List<StatusDetails> statusDetails = ((PodResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).withName(podName)).delete();
        boolean podDeleted = ObjectHelper.isNotEmpty(statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, podDeleted);
    }
}

