/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ReplicationControllersConsumerTask rcWatcher;

    public KubernetesReplicationControllersConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.rcWatcher = new ReplicationControllersConsumerTask();
        this.executor.submit(this.rcWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Replication Controllers Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.rcWatcher, this.rcWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ReplicationControllersConsumerTask
    implements Runnable {
        private Watch watch;

        ReplicationControllersConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> w = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers();
            ObjectHelper.ifNotEmpty(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), w::inNamespace);
            if (ObjectHelper.isNotEmpty(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), w::withName);
            this.watch = w.watch(new Watcher<ReplicationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, ReplicationController resource) {
                    Exchange exchange = KubernetesReplicationControllersConsumer.this.createExchange(false);
                    exchange.getIn().setBody(resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        KubernetesReplicationControllersConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesReplicationControllersConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        KubernetesReplicationControllersConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

