/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.secrets;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSecretsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSecretsProducer.class);

    public KubernetesSecretsProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listSecrets": {
                this.doList(exchange);
                break;
            }
            case "listSecretsByLabels": {
                this.doListSecretsByLabels(exchange);
                break;
            }
            case "getSecret": {
                this.doGetSecret(exchange);
                break;
            }
            case "createSecret": {
                this.doCreateSecret(exchange);
                break;
            }
            case "updateSecret": {
                this.doUpdateSecret(exchange);
                break;
            }
            case "deleteSecret": {
                this.doDeleteSecret(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        SecretList secretsList = (SecretList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, secretsList.getItems());
    }

    protected void doListSecretsByLabels(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesSecretsLabels", Map.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        SecretList secretsList = !ObjectHelper.isEmpty(namespaceName) ? (SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).withLabels(labels)).list() : (SecretList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, secretsList.getItems());
    }

    protected void doGetSecret(Exchange exchange) {
        String secretName = exchange.getIn().getHeader("CamelKubernetesSecretName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(secretName)) {
            LOG.error("Get a specific Secret require specify a Secret name");
            throw new IllegalArgumentException("Get a specific Secret require specify a Secret name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Get a specific Secret require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Secret require specify a namespace name");
        }
        Secret secret = (Secret)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).withName(secretName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, secret);
    }

    protected void doUpdateSecret(Exchange exchange) {
        this.doCreateOrUpdateSecret(exchange, "Update", Updatable::update);
    }

    protected void doCreateSecret(Exchange exchange) {
        this.doCreateOrUpdateSecret(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateSecret(Exchange exchange, String operationName, Function<Resource<Secret>, Secret> operation) {
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Secret secretToCreate = exchange.getIn().getHeader("CamelKubernetesSecret", Secret.class);
        HashMap secretAnnotations = exchange.getIn().getHeader("CamelKubernetesSecretsAnnotations", HashMap.class);
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("{} a specific secret require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific secret require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty(secretToCreate)) {
            LOG.error("{} a specific secret require specify a secret bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific secret require specify a secret bean", operationName));
        }
        if (ObjectHelper.isNotEmpty(secretAnnotations)) {
            secretToCreate.getMetadata().setAnnotations(secretAnnotations);
        }
        Secret secret = operation.apply((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).resource(secretToCreate));
        KubernetesHelper.prepareOutboundMessage(exchange, secret);
    }

    protected void doDeleteSecret(Exchange exchange) {
        String secretName = exchange.getIn().getHeader("CamelKubernetesSecretName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(secretName)) {
            LOG.error("Delete a specific secret require specify a secret name");
            throw new IllegalArgumentException("Delete a specific secret require specify a secret name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Delete a specific secret require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific secret require specify a namespace name");
        }
        List<StatusDetails> statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).withName(secretName)).delete();
        boolean secretDeleted = ObjectHelper.isNotEmpty(statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, secretDeleted);
    }
}

