/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift.deploymentconfigs;

import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftDeploymentConfigsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftDeploymentConfigsProducer.class);

    public OpenshiftDeploymentConfigsProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listDeploymentConfigs": {
                this.doList(exchange);
                break;
            }
            case "listDeploymentConfigsByLabels": {
                this.doListDeploymentConfigsByLabels(exchange);
                break;
            }
            case "getDeploymentConfig": {
                this.doGetDeploymentConfig(exchange);
                break;
            }
            case "deleteDeploymentConfig": {
                this.doDeleteDeploymentConfig(exchange);
                break;
            }
            case "createDeploymentConfig": {
                this.doCreateDeployment(exchange);
                break;
            }
            case "updateDeploymentConfig": {
                this.doUpdateDeployment(exchange);
                break;
            }
            case "scaleDeploymentConfig": {
                this.doScaleDeploymentConfig(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        DeploymentConfigList deploymentConfigList = (DeploymentConfigList)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs().list();
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentConfigList.getItems());
    }

    protected void doListDeploymentConfigsByLabels(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesDeploymentsLabels", Map.class);
        DeploymentConfigList deploymentConfigList = (DeploymentConfigList)((FilterWatchListDeletable)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs().withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentConfigList.getItems());
    }

    protected void doGetDeploymentConfig(Exchange exchange) {
        String deploymentConfigName = exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        if (ObjectHelper.isEmpty(deploymentConfigName)) {
            LOG.error("Get a specific Deployment Config require specify a Deployment name");
            throw new IllegalArgumentException("Get a specific Deployment Config require specify a Deployment Config name");
        }
        DeploymentConfig deploymentConfig = (DeploymentConfig)((DeployableScalableResource)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs().withName(deploymentConfigName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentConfig);
    }

    protected void doDeleteDeploymentConfig(Exchange exchange) {
        String deploymentName = exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(deploymentName)) {
            LOG.error("Delete a specific deployment config require specify a deployment name");
            throw new IllegalArgumentException("Delete a specific deployment require specify a deployment config name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Delete a specific deployment config require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific deployment config require specify a namespace name");
        }
        List<StatusDetails> statusDetails = ((DeployableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs().inNamespace(namespaceName)).withName(deploymentName)).delete();
        boolean deploymentConfigDeleted = ObjectHelper.isNotEmpty(statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentConfigDeleted);
    }

    protected void doUpdateDeployment(Exchange exchange) {
        this.doCreateOrUpdateDeployment(exchange, "Update", Updatable::update);
    }

    protected void doCreateDeployment(Exchange exchange) {
        this.doCreateOrUpdateDeployment(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateDeployment(Exchange exchange, String operationName, Function<Resource<DeploymentConfig>, DeploymentConfig> operation) {
        String deploymentName = exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        DeploymentConfigSpec dcSpec = exchange.getIn().getHeader("CamelKubernetesDeploymentConfigSpec", DeploymentConfigSpec.class);
        if (ObjectHelper.isEmpty(deploymentName)) {
            LOG.error("{} a specific Deployment Config require specify a Deployment name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Deployment Config require specify a pod name", operationName));
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("{} a specific Deployment Config require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Deployment Config require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty(dcSpec)) {
            LOG.error("{} a specific Deployment Config require specify a Deployment Config spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Deployment Config require specify a Deployment Config spec bean", operationName));
        }
        Map labels = exchange.getIn().getHeader("CamelKubernetesDeploymentsLabels", Map.class);
        DeploymentConfig deploymentCreating = ((DeploymentConfigBuilder)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(deploymentName)).withLabels(labels)).endMetadata()).withSpec(dcSpec)).build();
        DeploymentConfig deploymentConfig = operation.apply((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs().inNamespace(namespaceName)).resource(deploymentCreating));
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentConfig);
    }

    protected void doScaleDeploymentConfig(Exchange exchange) {
        String deploymentName = exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Integer replicasNumber = exchange.getIn().getHeader("CamelKubernetesDeploymentReplicas", Integer.class);
        if (ObjectHelper.isEmpty(deploymentName)) {
            LOG.error("Scale a specific deployment config require specify a deployment config name");
            throw new IllegalArgumentException("Scale a specific deployment config require specify a deployment config name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Scale a specific deployment config require specify a namespace name");
            throw new IllegalArgumentException("Scale a specific deployment config require specify a namespace name");
        }
        if (ObjectHelper.isEmpty(replicasNumber)) {
            LOG.error("Scale a specific deployment config require specify a replicas number");
            throw new IllegalArgumentException("Scale a specific deployment config require specify a replicas number");
        }
        DeploymentConfig deploymentConfigScaled = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).deploymentConfigs().inNamespace(namespaceName)).withName(deploymentName)).scale(replicasNumber, false);
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentConfigScaled.getStatus().getReplicas());
    }
}

