/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceChooserAware;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryAware;
import org.apache.camel.cloud.ServiceExpressionFactory;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceFilterAware;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.impl.cloud.DefaultServiceCallExpression;
import org.apache.camel.impl.cloud.DefaultServiceCallProcessor;
import org.apache.camel.impl.cloud.DefaultServiceLoadBalancer;
import org.apache.camel.impl.cloud.HealthyServiceFilter;
import org.apache.camel.impl.cloud.PassThroughServiceFilter;
import org.apache.camel.impl.cloud.RandomServiceChooser;
import org.apache.camel.impl.cloud.RoundRobinServiceChooser;
import org.apache.camel.model.Model;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.TypedProcessorFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingHelper;

@Deprecated(since="3.19.0")
public class ServiceCallProcessorFactory
extends TypedProcessorFactory<ServiceCallDefinition> {
    private volatile ServiceCallDefinition definition;

    public ServiceCallProcessorFactory() {
        super(ServiceCallDefinition.class);
    }

    @Override
    public Processor doCreateProcessor(Route route, ServiceCallDefinition definition) throws Exception {
        ServiceCallConfigurationDefinition conf;
        String endpointUri;
        ServiceCallConfigurationDefinition conf2;
        String endpointScheme;
        this.definition = definition;
        CamelContext camelContext = route.getCamelContext();
        ServiceDiscovery serviceDiscovery = this.retrieveServiceDiscovery(camelContext);
        ServiceFilter serviceFilter = this.retrieveServiceFilter(camelContext);
        ServiceChooser serviceChooser = this.retrieveServiceChooser(camelContext);
        ServiceLoadBalancer loadBalancer = this.retrieveLoadBalancer(camelContext);
        CamelContextAware.trySetCamelContext(serviceDiscovery, camelContext);
        CamelContextAware.trySetCamelContext(serviceFilter, camelContext);
        CamelContextAware.trySetCamelContext(serviceChooser, camelContext);
        CamelContextAware.trySetCamelContext(loadBalancer, camelContext);
        if (loadBalancer instanceof ServiceDiscoveryAware) {
            ServiceDiscoveryAware serviceDiscoveryAware = (ServiceDiscoveryAware)((Object)loadBalancer);
            serviceDiscoveryAware.setServiceDiscovery(serviceDiscovery);
        }
        if (loadBalancer instanceof ServiceFilterAware) {
            ServiceFilterAware serviceFilterAware = (ServiceFilterAware)((Object)loadBalancer);
            serviceFilterAware.setServiceFilter(serviceFilter);
        }
        if (loadBalancer instanceof ServiceChooserAware) {
            ServiceChooserAware serviceChooserAware = (ServiceChooserAware)((Object)loadBalancer);
            serviceChooserAware.setServiceChooser(serviceChooser);
        }
        if ((endpointScheme = definition.getComponent()) == null && (conf2 = this.retrieveConfig(camelContext)) != null) {
            endpointScheme = conf2.getComponent();
        }
        if (endpointScheme == null && (conf2 = this.retrieveDefaultConfig(camelContext)) != null) {
            endpointScheme = conf2.getComponent();
        }
        if ((endpointUri = definition.getUri()) == null && (conf = this.retrieveConfig(camelContext)) != null) {
            endpointUri = conf.getUri();
        }
        if (endpointUri == null && (conf = this.retrieveDefaultConfig(camelContext)) != null) {
            endpointUri = conf.getUri();
        }
        ObjectHelper.notNull(definition.getName(), "Service name");
        endpointScheme = ThrowingHelper.applyIfNotEmpty(endpointScheme, camelContext::resolvePropertyPlaceholders, () -> "http");
        endpointUri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(camelContext, endpointUri);
        ExchangePattern pattern = CamelContextHelper.parse(camelContext, ExchangePattern.class, definition.getPattern());
        Expression expression = this.retrieveExpression(camelContext, endpointScheme);
        if (expression instanceof ExpressionFactory) {
            ExpressionFactory expressionFactory = (ExpressionFactory)((Object)expression);
            expression = expressionFactory.createExpression(camelContext);
        }
        return new DefaultServiceCallProcessor(camelContext, camelContext.resolvePropertyPlaceholders(definition.getName()), endpointScheme, endpointUri, pattern, loadBalancer, expression);
    }

    private ServiceCallConfigurationDefinition retrieveDefaultConfig(CamelContext camelContext) {
        ServiceCallConfigurationDefinition config = camelContext.getCamelContextExtension().getContextPlugin(Model.class).getServiceCallConfiguration(null);
        if (config == null) {
            config = CamelContextHelper.lookup(camelContext, "service-call-configuration", ServiceCallConfigurationDefinition.class);
        }
        if (config == null) {
            config = CamelContextHelper.findSingleByType(camelContext, ServiceCallConfigurationDefinition.class);
        }
        return config;
    }

    private ServiceCallConfigurationDefinition retrieveConfig(CamelContext camelContext) {
        ServiceCallConfigurationDefinition config = null;
        if (this.definition.getConfigurationRef() != null && (config = CamelContextHelper.lookup(camelContext, this.definition.getConfigurationRef(), ServiceCallConfigurationDefinition.class)) == null) {
            config = camelContext.getCamelContextExtension().getContextPlugin(Model.class).getServiceCallConfiguration(this.definition.getConfigurationRef());
        }
        return config;
    }

    private ServiceDiscovery retrieveServiceDiscovery(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceDiscovery answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getServiceDiscoveryConfiguration() != null ? config.getServiceDiscoveryConfiguration().newInstance(camelContext) : this.retrieve(ServiceDiscovery.class, camelContext, config::getServiceDiscovery, config::getServiceDiscoveryRef);
        }
        return answer;
    }

    private ServiceDiscovery retrieveServiceDiscovery(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.definition.getServiceDiscoveryConfiguration() != null ? this.definition.getServiceDiscoveryConfiguration().newInstance(camelContext) : null, () -> this.retrieve(ServiceDiscovery.class, camelContext, this.definition::getServiceDiscovery, this.definition::getServiceDiscoveryRef), () -> this.retrieveServiceDiscovery(camelContext, this::retrieveConfig), () -> this.retrieveServiceDiscovery(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findSingleByType(camelContext, ServiceDiscovery.class), () -> CamelContextHelper.lookup(camelContext, "service-discovery", ServiceDiscovery.class)).orElseGet(() -> null);
    }

    private ServiceFilter retrieveServiceFilter(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceFilter answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null && (answer = config.getServiceFilterConfiguration() != null ? config.getServiceFilterConfiguration().newInstance(camelContext) : this.retrieve(ServiceFilter.class, camelContext, config::getServiceFilter, config::getServiceFilterRef)) == null) {
            String ref = config.getServiceFilterRef();
            if (ObjectHelper.equal("healthy", ref, true)) {
                answer = new HealthyServiceFilter();
            } else if (ObjectHelper.equal("pass-through", ref, true)) {
                answer = new PassThroughServiceFilter();
            } else if (ObjectHelper.equal("passthrough", ref, true)) {
                answer = new PassThroughServiceFilter();
            }
        }
        return answer;
    }

    private ServiceFilter retrieveServiceFilter(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.definition.getServiceFilterConfiguration() != null ? this.definition.getServiceFilterConfiguration().newInstance(camelContext) : null, () -> this.retrieve(ServiceFilter.class, camelContext, this.definition::getServiceFilter, this.definition::getServiceFilterRef), () -> this.retrieveServiceFilter(camelContext, this::retrieveConfig), () -> this.retrieveServiceFilter(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findSingleByType(camelContext, ServiceFilter.class), () -> CamelContextHelper.lookup(camelContext, "service-filter", ServiceFilter.class)).orElseGet(() -> new HealthyServiceFilter());
    }

    private ServiceChooser retrieveServiceChooser(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) {
        ServiceChooser answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = this.retrieve(ServiceChooser.class, camelContext, config::getServiceChooser, config::getServiceChooserRef);
            if (answer == null) {
                String ref = config.getServiceChooserRef();
                if (ObjectHelper.equal("roundrobin", ref, true)) {
                    answer = new RoundRobinServiceChooser();
                } else if (ObjectHelper.equal("round-robin", ref, true)) {
                    answer = new RoundRobinServiceChooser();
                } else if (ObjectHelper.equal("random", ref, true)) {
                    answer = new RandomServiceChooser();
                }
            }
        }
        return answer;
    }

    private ServiceChooser retrieveServiceChooser(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.retrieve(ServiceChooser.class, camelContext, this.definition::getServiceChooser, this.definition::getServiceChooserRef), () -> this.retrieveServiceChooser(camelContext, this::retrieveConfig), () -> this.retrieveServiceChooser(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findSingleByType(camelContext, ServiceChooser.class), () -> CamelContextHelper.lookup(camelContext, "service-chooser", ServiceChooser.class)).orElseGet(() -> new RoundRobinServiceChooser());
    }

    private ServiceLoadBalancer retrieveLoadBalancer(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceLoadBalancer answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getLoadBalancerConfiguration() != null ? config.getLoadBalancerConfiguration().newInstance(camelContext) : this.retrieve(ServiceLoadBalancer.class, camelContext, config::getLoadBalancer, config::getLoadBalancerRef);
        }
        return answer;
    }

    private ServiceLoadBalancer retrieveLoadBalancer(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.definition.getLoadBalancerConfiguration() != null ? this.definition.getLoadBalancerConfiguration().newInstance(camelContext) : null, () -> this.retrieve(ServiceLoadBalancer.class, camelContext, this.definition::getLoadBalancer, this.definition::getLoadBalancerRef), () -> this.retrieveLoadBalancer(camelContext, this::retrieveConfig), () -> this.retrieveLoadBalancer(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findSingleByType(camelContext, ServiceLoadBalancer.class), () -> CamelContextHelper.lookup(camelContext, "load-balancer", ServiceLoadBalancer.class)).orElseGet(DefaultServiceLoadBalancer::new);
    }

    private Expression retrieveExpression(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        Expression answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getExpressionConfiguration() != null ? config.getExpressionConfiguration().newInstance(camelContext) : this.retrieve(Expression.class, camelContext, config::getExpression, config::getExpressionRef);
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression retrieveExpression(CamelContext camelContext, String component) throws Exception {
        Optional expression = Suppliers.firstNotNull(() -> this.definition.getExpressionConfiguration() != null ? this.definition.getExpressionConfiguration().newInstance(camelContext) : null, () -> this.retrieve(Expression.class, camelContext, this.definition::getExpression, this.definition::getExpressionRef), () -> this.retrieveExpression(camelContext, this::retrieveConfig), () -> this.retrieveExpression(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.lookup(camelContext, "service-call-expression", Expression.class));
        if (expression.isPresent()) {
            return (Expression)expression.get();
        }
        String lookupName = component + "-service-expression";
        ServiceExpressionFactory factory2 = CamelContextHelper.lookup(camelContext, lookupName, ServiceExpressionFactory.class);
        if (factory2 != null) {
            return (Expression)factory2.newInstance(camelContext);
        }
        Class type = null;
        try {
            type = camelContext.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(lookupName).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ObjectHelper.isNotEmpty(type)) {
            if (!ServiceExpressionFactory.class.isAssignableFrom(type)) throw new IllegalArgumentException("Resolving Expression: " + lookupName + " detected type conflict: Not a ServiceExpressionFactory implementation. Found: " + type.getName());
            factory2 = (ServiceExpressionFactory)camelContext.getInjector().newInstance(type, false);
            return (Expression)factory2.newInstance(camelContext);
        } else {
            factory2 = context -> new DefaultServiceCallExpression();
        }
        return (Expression)factory2.newInstance(camelContext);
    }

    private <T> T retrieve(Class<T> type, CamelContext camelContext, Supplier<T> instanceSupplier, Supplier<String> refSupplier) {
        String ref;
        T answer = null;
        if (instanceSupplier != null) {
            answer = instanceSupplier.get();
        }
        if (answer == null && refSupplier != null && (ref = refSupplier.get()) != null) {
            answer = CamelContextHelper.lookup(camelContext, ref, type);
        }
        return answer;
    }
}

