/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.DefaultOpenAiClient;
import dev.ai4j.openai4j.LogLevel;
import dev.ai4j.openai4j.SyncOrAsync;
import dev.ai4j.openai4j.SyncOrAsyncOrStreaming;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.ai4j.openai4j.image.GenerateImagesRequest;
import dev.ai4j.openai4j.image.GenerateImagesResponse;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import dev.ai4j.openai4j.spi.OpenAiClientBuilderFactory;
import dev.ai4j.openai4j.spi.ServiceHelper;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class OpenAiClient {
    public abstract SyncOrAsyncOrStreaming<CompletionResponse> completion(CompletionRequest var1);

    public abstract SyncOrAsyncOrStreaming<String> completion(String var1);

    public abstract SyncOrAsyncOrStreaming<ChatCompletionResponse> chatCompletion(ChatCompletionRequest var1);

    public abstract SyncOrAsyncOrStreaming<String> chatCompletion(String var1);

    public abstract SyncOrAsync<EmbeddingResponse> embedding(EmbeddingRequest var1);

    public abstract SyncOrAsync<List<Float>> embedding(String var1);

    public abstract SyncOrAsync<ModerationResponse> moderation(ModerationRequest var1);

    public abstract SyncOrAsync<ModerationResult> moderation(String var1);

    public abstract SyncOrAsync<GenerateImagesResponse> imagesGeneration(GenerateImagesRequest var1);

    public abstract void shutdown();

    public static Builder builder() {
        Iterator<OpenAiClientBuilderFactory> iterator2 = ServiceHelper.loadFactories(OpenAiClientBuilderFactory.class).iterator();
        if (iterator2.hasNext()) {
            OpenAiClientBuilderFactory factory2 = iterator2.next();
            return (Builder)factory2.get();
        }
        return DefaultOpenAiClient.builder();
    }

    public static abstract class Builder<T extends OpenAiClient, B extends Builder<T, B>> {
        public String baseUrl = "https://api.openai.com/v1/";
        public String organizationId;
        public String apiVersion;
        public String openAiApiKey;
        public String azureApiKey;
        public Duration callTimeout = Duration.ofSeconds(60L);
        public Duration connectTimeout = Duration.ofSeconds(60L);
        public Duration readTimeout = Duration.ofSeconds(60L);
        public Duration writeTimeout = Duration.ofSeconds(60L);
        public Proxy proxy;
        public String userAgent;
        public boolean logRequests;
        public boolean logResponses;
        public LogLevel logLevel = LogLevel.DEBUG;
        public boolean logStreamingResponses;
        public Path persistTo;
        public Map<String, String> customHeaders;

        public abstract T build();

        public B baseUrl(String baseUrl) {
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("baseUrl cannot be null or empty");
            }
            this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
            return (B)this;
        }

        public B organizationId(String organizationId) {
            this.organizationId = organizationId;
            return (B)this;
        }

        public B apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return (B)this;
        }

        public B openAiApiKey(String openAiApiKey) {
            if (openAiApiKey == null || openAiApiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("openAiApiKey cannot be null or empty. API keys can be generated here: https://platform.openai.com/account/api-keys");
            }
            this.openAiApiKey = openAiApiKey;
            return (B)this;
        }

        public B azureApiKey(String azureApiKey) {
            if (azureApiKey == null || azureApiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("azureApiKey cannot be null or empty");
            }
            this.azureApiKey = azureApiKey;
            return (B)this;
        }

        public B callTimeout(Duration callTimeout) {
            if (callTimeout == null) {
                throw new IllegalArgumentException("callTimeout cannot be null");
            }
            this.callTimeout = callTimeout;
            return (B)this;
        }

        public B connectTimeout(Duration connectTimeout) {
            if (connectTimeout == null) {
                throw new IllegalArgumentException("connectTimeout cannot be null");
            }
            this.connectTimeout = connectTimeout;
            return (B)this;
        }

        public B readTimeout(Duration readTimeout) {
            if (readTimeout == null) {
                throw new IllegalArgumentException("readTimeout cannot be null");
            }
            this.readTimeout = readTimeout;
            return (B)this;
        }

        public B writeTimeout(Duration writeTimeout) {
            if (writeTimeout == null) {
                throw new IllegalArgumentException("writeTimeout cannot be null");
            }
            this.writeTimeout = writeTimeout;
            return (B)this;
        }

        public B proxy(Proxy.Type type, String ip, int port) {
            this.proxy = new Proxy(type, new InetSocketAddress(ip, port));
            return (B)this;
        }

        public B proxy(Proxy proxy) {
            this.proxy = proxy;
            return (B)this;
        }

        public B userAgent(String userAgent) {
            this.userAgent = userAgent;
            return (B)this;
        }

        public B logRequests() {
            return this.logRequests(true);
        }

        public B logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logLevel(LogLevel logLevel) {
            if (logLevel == null) {
                logLevel = LogLevel.DEBUG;
            }
            this.logLevel = logLevel;
            return (B)this;
        }

        public B logResponses() {
            return this.logResponses(true);
        }

        public B logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return (B)this;
        }

        public B logStreamingResponses() {
            return this.logStreamingResponses(true);
        }

        public B logStreamingResponses(Boolean logStreamingResponses) {
            if (logStreamingResponses == null) {
                logStreamingResponses = false;
            }
            this.logStreamingResponses = logStreamingResponses;
            return (B)this;
        }

        public B withPersisting() {
            this.persistTo = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            return (B)this;
        }

        public B persistTo(Path persistTo) {
            this.persistTo = persistTo;
            return (B)this;
        }

        public B customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return (B)this;
        }
    }
}

