/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ToolExecutionRequestUtil {
    private static final Pattern TRAILING_COMMA_PATTERN = Pattern.compile(",(\\s*[}\\]])");
    private static final Gson GSON = new Gson();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();

    private ToolExecutionRequestUtil() {
    }

    static Map<String, Object> argumentsAsMap(String arguments) {
        return (Map)GSON.fromJson(ToolExecutionRequestUtil.removeTrailingComma(arguments), MAP_TYPE);
    }

    static String removeTrailingComma(String json) {
        if (json == null || json.isEmpty()) {
            return json;
        }
        Matcher matcher = TRAILING_COMMA_PATTERN.matcher(json);
        return matcher.replaceAll("$1");
    }
}

