/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;

public abstract class AbstractTypedParamTool<T, P>
extends TypedCmdLineTool<T> {
    protected final Class<P> paramsClass;

    protected AbstractTypedParamTool(Class<T> sampleType, Class<P> paramsClass) {
        super(sampleType);
        this.paramsClass = paramsClass;
    }

    @Override
    public String getHelp(String format) {
        if ("".equals(format) || "opennlp".equals(format)) {
            return this.getBasicHelp(this.paramsClass, StreamFactoryRegistry.getFactory(this.type, "opennlp").getParameters());
        }
        ObjectStreamFactory factory2 = StreamFactoryRegistry.getFactory(this.type, format);
        if (null == factory2) {
            throw new TerminateToolException(1, "Format " + format + " is not found.\n" + this.getHelp());
        }
        return "Usage: opennlp " + this.getName() + "." + format + " " + ArgumentParser.createUsage(this.paramsClass, factory2.getParameters());
    }
}

