/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CLI;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TypedCmdLineTool;

public class GenerateManualTool {
    private static final int MAX_LINE_LENGTH = 110;

    public static void main(String[] args2) throws FileNotFoundException {
        if (args2.length != 1) {
            System.out.print(GenerateManualTool.getUsage());
            System.exit(0);
        }
        StringBuilder sb = new StringBuilder();
        GenerateManualTool.appendHeader(sb);
        LinkedHashMap packageNameToolMap = new LinkedHashMap();
        for (Map.Entry<String, CmdLineTool> entry : CLI.getToolLookupMap().entrySet()) {
            String toolName = entry.getKey();
            CmdLineTool tool = entry.getValue();
            String packageName = tool.getClass().getPackage().getName();
            if (!packageNameToolMap.containsKey(packageName = packageName.substring(packageName.lastIndexOf(".") + 1))) {
                packageNameToolMap.put(packageName, new LinkedHashMap());
            }
            ((Map)packageNameToolMap.get(packageName)).put(toolName, tool);
        }
        for (Map.Entry<String, CmdLineTool> entry : packageNameToolMap.entrySet()) {
            GenerateManualTool.appendToolGroup(entry.getKey(), (Map)((Object)entry.getValue()), sb);
        }
        GenerateManualTool.appendFooter(sb);
        Throwable throwable = null;
        try (PrintWriter out = new PrintWriter(args2[0]);){
            out.println(sb);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private static String getUsage() {
        return "Requires one argument: \n  Path to the output XML file \n";
    }

    private static void appendToolGroup(String groupName, Map<String, CmdLineTool> toolsMap, StringBuilder sb) {
        sb.append("<section id='tools.cli.").append(groupName).append("'>\n\n");
        sb.append("<title>").append(GenerateManualTool.firstCaps(groupName)).append("</title>\n\n");
        for (Map.Entry<String, CmdLineTool> entry : toolsMap.entrySet()) {
            GenerateManualTool.appendTool(groupName, entry.getKey(), entry.getValue(), sb);
        }
        sb.append("</section>\n\n");
    }

    private static void appendTool(String groupName, String toolName, CmdLineTool tool, StringBuilder sb) {
        sb.append("<section id='tools.cli.").append(groupName).append(".").append(toolName).append("'>\n\n");
        sb.append("<title>").append(toolName).append("</title>\n\n");
        sb.append("<para>").append(GenerateManualTool.firstCaps(tool.getShortDescription())).append("</para>\n\n");
        GenerateManualTool.appendCode(tool.getHelp(), sb);
        if (TypedCmdLineTool.class.isAssignableFrom(tool.getClass())) {
            GenerateManualTool.appendHelpForTool((TypedCmdLineTool)tool, sb);
        }
        sb.append("</section>\n\n");
    }

    private static void appendHelpForTool(TypedCmdLineTool<?> tool, StringBuilder sb) {
        Class type = tool.type;
        Set<String> formats = StreamFactoryRegistry.getFactories(type).keySet();
        sb.append("<para>The supported formats and arguments are:</para>\n\n");
        LinkedHashMap<String, List<ArgumentParser.Argument>> formatArguments = new LinkedHashMap<String, List<ArgumentParser.Argument>>();
        for (String formatName : formats) {
            if ("opennlp".equals(formatName)) continue;
            ObjectStreamFactory<?> format = tool.getStreamFactory(formatName);
            formatArguments.put(formatName, ArgumentParser.createArguments(format.getParameters()));
        }
        GenerateManualTool.appendArgumentTable(formatArguments, sb);
    }

    private static void appendArgumentTable(Map<String, List<ArgumentParser.Argument>> formatArguments, StringBuilder sb) {
        sb.append("<informaltable frame='all'><tgroup cols='4' align='left' colsep='1' rowsep='1'>\n");
        sb.append("<thead><row><entry>Format</entry><entry>Argument</entry><entry>Value</entry><entry>Optional</entry><entry>Description</entry></row></thead>\n");
        sb.append("<tbody>\n");
        for (Map.Entry<String, List<ArgumentParser.Argument>> entry : formatArguments.entrySet()) {
            String format = entry.getKey();
            List<ArgumentParser.Argument> arguments = entry.getValue();
            int i = 0;
            for (ArgumentParser.Argument argument : arguments) {
                sb.append("<row>\n");
                if (i == 0) {
                    sb.append("<entry morerows='").append(arguments.size() - 1).append("' valign='middle'>").append(format).append("</entry>\n");
                }
                sb.append("<entry>").append(argument.getArgument()).append("</entry>\n");
                sb.append("<entry>").append(argument.getValue()).append("</entry>\n");
                sb.append("<entry>").append(GenerateManualTool.yes(argument.getOptional())).append("</entry>\n");
                sb.append("<entry>").append(GenerateManualTool.firstCaps(argument.getDescription())).append("</entry>\n");
                sb.append("</row>\n");
                ++i;
            }
        }
        sb.append("</tbody>\n");
        sb.append("</tgroup></informaltable>\n\n");
    }

    private static void appendHeader(StringBuilder sb) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE chapter PUBLIC \"-//OASIS//DTD DocBook XML V4.4//EN\"\n\"http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd\"[\n]>\n<!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n   http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n\"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n-->\n\n\n<!-- ## Warning ## this content is autogenerated! Please fix issues in to opennlp-tools/src/main/java/opennlp/tools/cmdline/GenerateManualTool.java \n   and execute the following command in opennlp-tool folder to update this file: \n\n      mvn -e -q exec:java \"-Dexec.mainClass=opennlp.tools.cmdline.GenerateManualTool\" \"-Dexec.args=../opennlp-docs/src/docbkx/cli.xml\"\n-->\n\n<chapter id='tools.cli'>\n\n<title>The Command Line Interface</title>\n\n<para>This section details the available tools and parameters of the Command Line Interface. For a introduction in its usage please refer to <xref linkend='intro.cli'/>.  </para>\n\n");
    }

    private static void appendFooter(StringBuilder sb) {
        sb.append("\n\n</chapter>");
    }

    private static String firstCaps(String str) {
        if (str.length() > 1) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }

    private static String yes(boolean optional) {
        if (optional) {
            return "Yes";
        }
        return "No";
    }

    private static void appendCode(String help, StringBuilder sb) {
        sb.append("<screen>\n<![CDATA[\n").append(GenerateManualTool.splitLongLines(help)).append("\n").append("]]>\n").append("</screen> \n");
    }

    private static String splitLongLines(String stringBlock) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(stringBlock));
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 110) {
                    sb.append(line).append("\n");
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(line, " ");
                int lineLen = 0;
                while (tok.hasMoreTokens()) {
                    String word = tok.nextToken() + " ";
                    if (lineLen + word.length() > 110) {
                        sb.append("\n        ");
                        lineLen = 8;
                    }
                    sb.append(word);
                    lineLen += word.length();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }
}

