/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluSentenceSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

public class ConlluSentenceSampleStreamFactory
extends AbstractSampleStreamFactory<SentenceSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "conllu", new ConlluSentenceSampleStreamFactory(Parameters.class));
    }

    protected <P> ConlluSentenceSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args2) {
        Parameters params = ArgumentParser.parse(args2, Parameters.class);
        InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory(params.getData());
        try {
            return new ConlluSentenceSampleStream(new ConlluStream(inFactory), Integer.parseInt(params.getSentencesPerSample()));
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="sentencesPerSample", description="number of sentences per sample")
        public String getSentencesPerSample();
    }
}

