/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class SequenceStreamEventStream
implements ObjectStream<Event> {
    private final SequenceStream sequenceStream;
    private Iterator<Event> eventIt = Collections.emptyListIterator();

    public SequenceStreamEventStream(SequenceStream sequenceStream) {
        this.sequenceStream = sequenceStream;
    }

    @Override
    public Event read() throws IOException {
        while (!this.eventIt.hasNext()) {
            Sequence sequence2 = (Sequence)this.sequenceStream.read();
            if (sequence2 == null) {
                return null;
            }
            this.eventIt = Arrays.asList(sequence2.getEvents()).iterator();
        }
        return this.eventIt.next();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.eventIt = Collections.emptyListIterator();
        this.sequenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.eventIt = Collections.emptyListIterator();
        this.sequenceStream.close();
    }
}

