/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.Content;
import dev.ai4j.openai4j.chat.ContentType;
import dev.ai4j.openai4j.chat.ImageDetail;
import dev.ai4j.openai4j.chat.ImageUrl;
import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.Role;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class UserMessage
implements Message {
    private final Role role = Role.USER;
    private final Object content;
    private final String name;

    private UserMessage(Builder builder) {
        this.content = builder.stringContent != null ? builder.stringContent : builder.content;
        this.name = builder.name;
    }

    @Override
    public Role role() {
        return this.role;
    }

    public Object content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserMessage && this.equalTo((UserMessage)another);
    }

    private boolean equalTo(UserMessage another) {
        return Objects.equals((Object)this.role, (Object)another.role) && Objects.equals(this.content, another.content) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return "UserMessage{role=" + (Object)((Object)this.role) + ", content=" + this.content + ", name=" + this.name + "}";
    }

    public static UserMessage from(String text) {
        return UserMessage.builder().content(text).build();
    }

    public static UserMessage from(String text, String ... imageUrls) {
        return UserMessage.builder().addText(text).addImageUrls(imageUrls).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String stringContent;
        private List<Content> content;
        private String name;

        private Builder() {
        }

        public Builder addText(String text) {
            if (this.content == null) {
                this.content = new ArrayList<Content>();
            }
            Content content = Content.builder().type(ContentType.TEXT).text(text).build();
            this.content.add(content);
            return this;
        }

        public Builder addImageUrl(String imageUrl) {
            return this.addImageUrl(imageUrl, null);
        }

        public Builder addImageUrl(String imageUrl, ImageDetail imageDetail) {
            if (this.content == null) {
                this.content = new ArrayList<Content>();
            }
            Content content = Content.builder().type(ContentType.IMAGE_URL).imageUrl(ImageUrl.builder().url(imageUrl).detail(imageDetail).build()).build();
            this.content.add(content);
            return this;
        }

        public Builder addImageUrls(String ... imageUrls) {
            for (String imageUrl : imageUrls) {
                this.addImageUrl(imageUrl);
            }
            return this;
        }

        public Builder content(List<Content> content) {
            if (content != null) {
                this.content = Collections.unmodifiableList(content);
            }
            return this;
        }

        public Builder content(String content) {
            this.stringContent = content;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public UserMessage build() {
            return new UserMessage(this);
        }
    }
}

