/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class TextDocumentParser
implements DocumentParser {
    private final Charset charset;

    public TextDocumentParser() {
        this(StandardCharsets.UTF_8);
    }

    public TextDocumentParser(Charset charset) {
        this.charset = ValidationUtils.ensureNotNull(charset, "charset");
    }

    @Override
    public Document parse(InputStream inputStream2) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream2.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            String text = new String(buffer.toByteArray(), this.charset);
            if (Utils.isNullOrBlank(text)) {
                throw new BlankDocumentException();
            }
            return Document.from(text);
        }
        catch (BlankDocumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

