/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.splitter;

import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.HierarchicalDocumentSplitter;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;

public class DocumentByRegexSplitter
extends HierarchicalDocumentSplitter {
    private final String regex;
    private final String joinDelimiter;

    public DocumentByRegexSplitter(String regex, String joinDelimiter, int maxSegmentSizeInChars, int maxOverlapSizeInChars) {
        super(maxSegmentSizeInChars, maxOverlapSizeInChars, null, null);
        this.regex = ValidationUtils.ensureNotNull(regex, "regex");
        this.joinDelimiter = ValidationUtils.ensureNotNull(joinDelimiter, "joinDelimiter");
    }

    public DocumentByRegexSplitter(String regex, String joinDelimiter, int maxSegmentSizeInChars, int maxOverlapSizeInChars, DocumentSplitter subSplitter) {
        super(maxSegmentSizeInChars, maxOverlapSizeInChars, null, subSplitter);
        this.regex = ValidationUtils.ensureNotNull(regex, "regex");
        this.joinDelimiter = ValidationUtils.ensureNotNull(joinDelimiter, "joinDelimiter");
    }

    public DocumentByRegexSplitter(String regex, String joinDelimiter, int maxSegmentSizeInTokens, int maxOverlapSizeInTokens, Tokenizer tokenizer) {
        super(maxSegmentSizeInTokens, maxOverlapSizeInTokens, tokenizer, null);
        this.regex = ValidationUtils.ensureNotNull(regex, "regex");
        this.joinDelimiter = ValidationUtils.ensureNotNull(joinDelimiter, "joinDelimiter");
    }

    public DocumentByRegexSplitter(String regex, String joinDelimiter, int maxSegmentSizeInTokens, int maxOverlapSizeInTokens, Tokenizer tokenizer, DocumentSplitter subSplitter) {
        super(maxSegmentSizeInTokens, maxOverlapSizeInTokens, tokenizer, subSplitter);
        this.regex = ValidationUtils.ensureNotNull(regex, "regex");
        this.joinDelimiter = ValidationUtils.ensureNotNull(joinDelimiter, "joinDelimiter");
    }

    @Override
    public String[] split(String text) {
        return text.split(this.regex);
    }

    @Override
    public String joinDelimiter() {
        return this.joinDelimiter;
    }

    @Override
    protected DocumentSplitter defaultSubSplitter() {
        return null;
    }
}

