/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.openai.OpenAiEmbeddingModelName;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiEmbeddingModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpenAiEmbeddingModel
extends DimensionAwareEmbeddingModel
implements TokenCountEstimator {
    private final OpenAiClient client;
    private final String modelName;
    private final Integer dimensions;
    private final String user;
    private final Integer maxRetries;
    private final Tokenizer tokenizer;

    public OpenAiEmbeddingModel(String baseUrl, String apiKey, String organizationId, String modelName, Integer dimensions, String user, Duration timeout2, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders) {
        baseUrl = Utils.getOrDefault(baseUrl, "https://api.openai.com/v1");
        if ("demo".equals(apiKey)) {
            baseUrl = "http://langchain4j.dev/demo/openai/v1";
        }
        timeout2 = Utils.getOrDefault(timeout2, Duration.ofSeconds(60L));
        this.client = ((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)OpenAiClient.builder().openAiApiKey(apiKey)).baseUrl(baseUrl)).organizationId(organizationId)).callTimeout(timeout2)).connectTimeout(timeout2)).readTimeout(timeout2)).writeTimeout(timeout2)).proxy(proxy)).logRequests(logRequests)).logResponses(logResponses)).userAgent("langchain4j-openai")).customHeaders(customHeaders)).build();
        this.modelName = Utils.getOrDefault(modelName, "text-embedding-ada-002");
        this.dimensions = dimensions;
        this.user = user;
        this.maxRetries = Utils.getOrDefault(maxRetries, 3);
        this.tokenizer = Utils.getOrDefault(tokenizer, OpenAiTokenizer::new);
    }

    @Override
    protected Integer knownDimension() {
        if (this.dimensions != null) {
            return this.dimensions;
        }
        return OpenAiEmbeddingModelName.knownDimension(this.modelName());
    }

    public String modelName() {
        return this.modelName;
    }

    @Override
    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(texts).model(this.modelName).dimensions(this.dimensions).user(this.user).build();
        EmbeddingResponse response = RetryUtils.withRetry(() -> this.client.embedding(request).execute(), this.maxRetries);
        List embeddings = response.data().stream().map(openAiEmbedding -> Embedding.from(openAiEmbedding.embedding())).collect(Collectors.toList());
        return Response.from(embeddings, InternalOpenAiHelper.tokenUsageFrom(response.usage()));
    }

    @Override
    public int estimateTokenCount(String text) {
        return this.tokenizer.estimateTokenCountInText(text);
    }

    public static OpenAiEmbeddingModel withApiKey(String apiKey) {
        return OpenAiEmbeddingModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiEmbeddingModelBuilder builder() {
        Iterator<OpenAiEmbeddingModelBuilderFactory> iterator2 = ServiceHelper.loadFactories(OpenAiEmbeddingModelBuilderFactory.class).iterator();
        if (iterator2.hasNext()) {
            OpenAiEmbeddingModelBuilderFactory factory2 = iterator2.next();
            return (OpenAiEmbeddingModelBuilder)factory2.get();
        }
        return new OpenAiEmbeddingModelBuilder();
    }

    public static class OpenAiEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Integer dimensions;
        private String user;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;

        public OpenAiEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiEmbeddingModelBuilder modelName(OpenAiEmbeddingModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiEmbeddingModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiEmbeddingModelBuilder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public OpenAiEmbeddingModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiEmbeddingModelBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public OpenAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiEmbeddingModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiEmbeddingModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiEmbeddingModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiEmbeddingModel build() {
            return new OpenAiEmbeddingModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.dimensions, this.user, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders);
        }

        public String toString() {
            return "OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", modelName=" + this.modelName + ", dimensions=" + this.dimensions + ", user=" + this.user + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", tokenizer=" + this.tokenizer + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

