/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionChoice;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.openai.OpenAiLanguageModelName;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiLanguageModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;

public class OpenAiLanguageModel
implements LanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Integer maxRetries;
    private final Tokenizer tokenizer;

    public OpenAiLanguageModel(String baseUrl, String apiKey, String organizationId, String modelName, Double temperature, Duration timeout2, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders) {
        timeout2 = Utils.getOrDefault(timeout2, Duration.ofSeconds(60L));
        this.client = ((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)OpenAiClient.builder().baseUrl(Utils.getOrDefault(baseUrl, "https://api.openai.com/v1"))).openAiApiKey(apiKey)).organizationId(organizationId)).callTimeout(timeout2)).connectTimeout(timeout2)).readTimeout(timeout2)).writeTimeout(timeout2)).proxy(proxy)).logRequests(logRequests)).logResponses(logResponses)).userAgent("langchain4j-openai")).customHeaders(customHeaders)).build();
        this.modelName = Utils.getOrDefault(modelName, "gpt-3.5-turbo-instruct");
        this.temperature = Utils.getOrDefault(temperature, 0.7);
        this.maxRetries = Utils.getOrDefault(maxRetries, 3);
        this.tokenizer = Utils.getOrDefault(tokenizer, OpenAiTokenizer::new);
    }

    public String modelName() {
        return this.modelName;
    }

    @Override
    public Response<String> generate(String prompt) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).temperature(this.temperature).build();
        CompletionResponse response = RetryUtils.withRetry(() -> (CompletionResponse)this.client.completion(request).execute(), this.maxRetries);
        CompletionChoice completionChoice = response.choices().get(0);
        return Response.from(completionChoice.text(), InternalOpenAiHelper.tokenUsageFrom(response.usage()), InternalOpenAiHelper.finishReasonFrom(completionChoice.finishReason()));
    }

    @Override
    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static OpenAiLanguageModel withApiKey(String apiKey) {
        return OpenAiLanguageModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiLanguageModelBuilder builder() {
        Iterator<OpenAiLanguageModelBuilderFactory> iterator2 = ServiceHelper.loadFactories(OpenAiLanguageModelBuilderFactory.class).iterator();
        if (iterator2.hasNext()) {
            OpenAiLanguageModelBuilderFactory factory2 = iterator2.next();
            return (OpenAiLanguageModelBuilder)factory2.get();
        }
        return new OpenAiLanguageModelBuilder();
    }

    public static class OpenAiLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Double temperature;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;

        public OpenAiLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiLanguageModelBuilder modelName(OpenAiLanguageModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiLanguageModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiLanguageModelBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public OpenAiLanguageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiLanguageModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiLanguageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiLanguageModel build() {
            return new OpenAiLanguageModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.temperature, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders);
        }

        public String toString() {
            return "OpenAiLanguageModel.OpenAiLanguageModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", tokenizer=" + this.tokenizer + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

