/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.XmlUtil;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.BigramNameFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownClusterBigramFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.BrownClusterTokenClassFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.BrownClusterTokenFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.CharacterNgramFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.DefinitionFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.DictionaryFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.DocumentBeginFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.POSTaggerNameFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.PosTaggerFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.PrefixFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.PreviousMapFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.SentenceFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.SuffixFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.TokenClassFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.TokenFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.TokenPatternFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.WindowFeatureGeneratorFactory;
import opennlp.tools.util.featuregen.WordClusterDictionary;
import opennlp.tools.util.featuregen.WordClusterFeatureGeneratorFactory;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.DictionarySerializer;
import opennlp.tools.util.model.POSModelSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class GeneratorFactory {
    private static Map<String, XmlFeatureGeneratorFactory> factories = new HashMap<String, XmlFeatureGeneratorFactory>();

    @Deprecated
    static AdaptiveFeatureGenerator createGenerator(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
        String elementName = generatorElement.getTagName();
        if (elementName.equals("featureGenerators")) {
            ArrayList<AdaptiveFeatureGenerator> generators = new ArrayList<AdaptiveFeatureGenerator>();
            NodeList childNodes = generatorElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element elem = (Element)childNode;
                String type = elem.getTagName();
                if (type.equals("generator")) {
                    generators.add(GeneratorFactory.buildGenerator(elem, resourceManager));
                    continue;
                }
                throw new InvalidFormatException("Unexpected element: " + elementName);
            }
            AdaptiveFeatureGenerator featureGenerator = null;
            if (generators.size() == 1) {
                featureGenerator = (AdaptiveFeatureGenerator)generators.get(0);
            } else if (generators.size() > 1) {
                featureGenerator = new AggregatedFeatureGenerator(generators.toArray(new AdaptiveFeatureGenerator[generators.size()]));
            } else {
                throw new InvalidFormatException("featureGenerators must have one or more generators");
            }
            if (featureGenerator instanceof CachedFeatureGenerator) {
                throw new InvalidFormatException("CachedFeatureGeneratorFactory cannot be specified manually.Use cache=\"true\" attribute in featureGenerators element instead.");
            }
            if (Boolean.parseBoolean(generatorElement.getAttribute("cache"))) {
                return new CachedFeatureGenerator(featureGenerator);
            }
            return featureGenerator;
        }
        XmlFeatureGeneratorFactory generatorFactory = factories.get(elementName);
        if (generatorFactory != null) {
            return generatorFactory.create(generatorElement, resourceManager);
        }
        throw new InvalidFormatException("Unexpected element: " + elementName);
    }

    static Element getFirstChild(Element elem) {
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            return (Element)nodes.item(i);
        }
        return null;
    }

    static AdaptiveFeatureGenerator buildGenerator(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
        String className = generatorElement.getAttribute("class");
        if (className == null) {
            throw new InvalidFormatException("generator must have class attribute");
        }
        try {
            Class<?> factoryClass = Class.forName(className);
            try {
                Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                AbstractXmlFeatureGeneratorFactory factory2 = (AbstractXmlFeatureGeneratorFactory)constructor.newInstance(new Object[0]);
                factory2.init(generatorElement, resourceManager);
                return factory2.create();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Document createDOM(InputStream xmlDescriptorIn) throws IOException {
        Document xmlDescriptorDOM;
        DocumentBuilder documentBuilder = XmlUtil.createDocumentBuilder();
        try {
            xmlDescriptorDOM = documentBuilder.parse(xmlDescriptorIn);
        }
        catch (SAXException e) {
            throw new InvalidFormatException("Descriptor is not valid XML!", e);
        }
        return xmlDescriptorDOM;
    }

    public static AdaptiveFeatureGenerator create(InputStream xmlDescriptorIn, FeatureGeneratorResourceProvider resourceManager) throws IOException {
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        Element generatorElement = xmlDescriptorDOM.getDocumentElement();
        return GeneratorFactory.createGenerator(generatorElement, resourceManager);
    }

    public static Map<String, ArtifactSerializer<?>> extractArtifactSerializerMappings(InputStream xmlDescriptorIn) throws IOException {
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        Element element = xmlDescriptorDOM.getDocumentElement();
        String elementName = element.getTagName();
        if (elementName.equals("featureGenerators")) {
            HashMap mapping = new HashMap();
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element childElem;
                if (!(nodes.item(i) instanceof Element) || !(childElem = (Element)nodes.item(i)).getTagName().equals("generator")) continue;
                GeneratorFactory.extractArtifactSerializerMappings(mapping, childElem);
            }
            return mapping;
        }
        return GeneratorFactory.extractArtifactSerializerMappingsClassicFormat(element);
    }

    static void extractArtifactSerializerMappings(Map<String, ArtifactSerializer<?>> mapping, Element element) {
        String className = element.getAttribute("class");
        if (className != null) {
            try {
                Class<?> factoryClass = Class.forName(className);
                try {
                    Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                    AbstractXmlFeatureGeneratorFactory factory2 = (AbstractXmlFeatureGeneratorFactory)constructor.newInstance(new Object[0]);
                    factory2.init(element, null);
                    Map<String, ArtifactSerializer<?>> map = factory2.getArtifactSerializerMapping();
                    if (map != null) {
                        mapping.putAll(map);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (InvalidFormatException e) {
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element childElem;
            if (!(nodes.item(i) instanceof Element) || !(childElem = (Element)nodes.item(i)).getTagName().equals("generator")) continue;
            GeneratorFactory.extractArtifactSerializerMappings(mapping, childElem);
        }
    }

    @Deprecated
    static Map<String, ArtifactSerializer<?>> extractArtifactSerializerMappingsClassicFormat(Element elem) throws IOException {
        NodeList allElements;
        NodeList customElements;
        HashMap mapping = new HashMap();
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression exp = xPath.compile("//custom");
            customElements = (NodeList)exp.evaluate(elem, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("The hard coded XPath expression should always be valid!");
        }
        for (int i = 0; i < customElements.getLength(); ++i) {
            Element customElement;
            AdaptiveFeatureGenerator generator;
            if (!(customElements.item(i) instanceof Element) || !((generator = GeneratorFactory.createGenerator(customElement = (Element)customElements.item(i), null)) instanceof ArtifactToSerializerMapper)) continue;
            ArtifactToSerializerMapper mapper = (ArtifactToSerializerMapper)((Object)generator);
            mapping.putAll(mapper.getArtifactSerializerMapping());
        }
        try {
            XPathExpression exp = xPath.compile("//*");
            allElements = (NodeList)exp.evaluate(elem, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("The hard coded XPath expression should always be valid!");
        }
        for (int i = 0; i < allElements.getLength(); ++i) {
            String modelName;
            if (!(allElements.item(i) instanceof Element)) continue;
            Element xmlElement = (Element)allElements.item(i);
            String dictName = xmlElement.getAttribute("dict");
            if (dictName != null) {
                switch (xmlElement.getTagName()) {
                    case "wordcluster": {
                        mapping.put(dictName, new WordClusterDictionary.WordClusterDictionarySerializer());
                        break;
                    }
                    case "brownclustertoken": {
                        mapping.put(dictName, new BrownCluster.BrownClusterSerializer());
                        break;
                    }
                    case "brownclustertokenclass": {
                        mapping.put(dictName, new BrownCluster.BrownClusterSerializer());
                        break;
                    }
                    case "brownclusterbigram": {
                        mapping.put(dictName, new BrownCluster.BrownClusterSerializer());
                        break;
                    }
                    case "dictionary": {
                        mapping.put(dictName, new DictionarySerializer());
                    }
                }
            }
            if ((modelName = xmlElement.getAttribute("model")) == null || !"tokenpos".equals(xmlElement.getTagName())) continue;
            mapping.put(modelName, new POSModelSerializer());
        }
        return mapping;
    }

    public static List<Element> getDescriptorElements(InputStream xmlDescriptorIn) throws IOException {
        NodeList allElements;
        ArrayList<Element> elements = new ArrayList<Element>();
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression exp = xPath.compile("//*");
            allElements = (NodeList)exp.evaluate(xmlDescriptorDOM.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("The hard coded XPath expression should always be valid!");
        }
        for (int i = 0; i < allElements.getLength(); ++i) {
            if (!(allElements.item(i) instanceof Element)) continue;
            Element customElement = (Element)allElements.item(i);
            elements.add(customElement);
        }
        return elements;
    }

    static {
        AggregatedFeatureGeneratorFactory.register(factories);
        CachedFeatureGeneratorFactory.register(factories);
        CharacterNgramFeatureGeneratorFactory.register(factories);
        DefinitionFeatureGeneratorFactory.register(factories);
        DictionaryFeatureGeneratorFactory.register(factories);
        DocumentBeginFeatureGeneratorFactory.register(factories);
        PreviousMapFeatureGeneratorFactory.register(factories);
        SentenceFeatureGeneratorFactory.register(factories);
        TokenClassFeatureGeneratorFactory.register(factories);
        TokenFeatureGeneratorFactory.register(factories);
        BigramNameFeatureGeneratorFactory.register(factories);
        TokenPatternFeatureGeneratorFactory.register(factories);
        PosTaggerFeatureGeneratorFactory.register(factories);
        PrefixFeatureGeneratorFactory.register(factories);
        SuffixFeatureGeneratorFactory.register(factories);
        WindowFeatureGeneratorFactory.register(factories);
        WordClusterFeatureGeneratorFactory.register(factories);
        BrownClusterTokenFeatureGeneratorFactory.register(factories);
        BrownClusterTokenClassFeatureGeneratorFactory.register(factories);
        BrownClusterBigramFeatureGeneratorFactory.register(factories);
        CustomFeatureGeneratorFactory.register(factories);
        POSTaggerNameFeatureGeneratorFactory.register(factories);
    }

    static class CustomFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CustomFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String featureGeneratorClassName = generatorElement.getAttribute("class");
            AdaptiveFeatureGenerator generator = ExtensionLoader.instantiateExtension(AdaptiveFeatureGenerator.class, featureGeneratorClassName);
            if (generator instanceof CustomFeatureGenerator) {
                CustomFeatureGenerator customGenerator = (CustomFeatureGenerator)generator;
                HashMap<String, String> properties = new HashMap<String, String>();
                NamedNodeMap attributes = generatorElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if ("class".equals(attribute.getNodeName())) continue;
                    properties.put(attribute.getNodeName(), attribute.getNodeValue());
                }
                if (resourceManager != null) {
                    customGenerator.init(properties, resourceManager);
                }
            }
            return generator;
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("custom", new CustomFeatureGeneratorFactory());
        }
    }

    public static abstract class AbstractXmlFeatureGeneratorFactory {
        protected Element generatorElement;
        protected FeatureGeneratorResourceProvider resourceManager;
        protected LinkedHashMap<String, Object> args = new LinkedHashMap();

        public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() throws InvalidFormatException {
            return null;
        }

        final void init(Element element, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            this.generatorElement = element;
            this.resourceManager = resourceManager;
            ArrayList<AdaptiveFeatureGenerator> generators = new ArrayList<AdaptiveFeatureGenerator>();
            NodeList childNodes = this.generatorElement.getChildNodes();
            block16: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element elem = (Element)childNode;
                String type = elem.getTagName();
                if (type.equals("generator")) {
                    String key = "generator#" + Integer.toString(generators.size());
                    AdaptiveFeatureGenerator afg = GeneratorFactory.buildGenerator(elem, resourceManager);
                    generators.add(afg);
                    if (afg == null) continue;
                    this.args.put(key, afg);
                    continue;
                }
                String name = elem.getAttribute("name");
                Node cn = elem.getFirstChild();
                Text text = (Text)cn;
                switch (type) {
                    case "int": {
                        this.args.put(name, Integer.parseInt(text.getWholeText()));
                        continue block16;
                    }
                    case "long": {
                        this.args.put(name, Long.parseLong(text.getWholeText()));
                        continue block16;
                    }
                    case "float": {
                        this.args.put(name, Float.valueOf(Float.parseFloat(text.getWholeText())));
                        continue block16;
                    }
                    case "double": {
                        this.args.put(name, Double.parseDouble(text.getWholeText()));
                        continue block16;
                    }
                    case "str": {
                        this.args.put(name, text.getWholeText());
                        continue block16;
                    }
                    case "bool": {
                        this.args.put(name, Boolean.parseBoolean(text.getWholeText()));
                        continue block16;
                    }
                    default: {
                        throw new InvalidFormatException("child element must be one of generator, int, long, float, double, str or bool");
                    }
                }
            }
            if (generators.size() > 1) {
                AggregatedFeatureGenerator aggregatedFeatureGenerator = new AggregatedFeatureGenerator(generators.toArray(new AdaptiveFeatureGenerator[generators.size()]));
                this.args.put("generator#0", aggregatedFeatureGenerator);
            }
        }

        public int getInt(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be integer!");
        }

        public int getInt(String name, int defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be integer!");
        }

        public long getLong(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be long!");
        }

        public long getLong(String name, long defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be long!");
        }

        public float getFloat(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            throw new InvalidFormatException("parameter " + name + " must be float!");
        }

        public float getFloat(String name, float defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            throw new InvalidFormatException("parameter " + name + " must be float!");
        }

        public double getDouble(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be double!");
        }

        public double getDouble(String name, double defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be double!");
        }

        public String getStr(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be double!");
        }

        public String getStr(String name, String defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be String!");
        }

        public boolean getBool(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be boolean!");
        }

        public boolean getBool(String name, boolean defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be boolean!");
        }

        public abstract AdaptiveFeatureGenerator create() throws InvalidFormatException;
    }

    @Deprecated
    static interface XmlFeatureGeneratorFactory {
        public AdaptiveFeatureGenerator create(Element var1, FeatureGeneratorResourceProvider var2) throws InvalidFormatException;
    }
}

