/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.embeddings;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.langchain4j.embeddings.LangChain4jEmbeddingsConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class LangChain4jEmbeddingsConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        LangChain4jEmbeddingsConverterLoader.addTypeConverter(registry, Embedding.class, float[].class, false, (type, exchange, value) -> LangChain4jEmbeddingsConverter.toEmbedding((float[])value));
        LangChain4jEmbeddingsConverterLoader.addTypeConverter(registry, Embedding.class, List.class, false, (type, exchange, value) -> LangChain4jEmbeddingsConverter.toEmbedding((List)value));
        LangChain4jEmbeddingsConverterLoader.addTypeConverter(registry, TextSegment.class, String.class, false, (type, exchange, value) -> LangChain4jEmbeddingsConverter.toTextSegment((String)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }
}

