/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.output.OutputParser;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Optional;

class EnumOutputParser
implements OutputParser<Enum> {
    private final Class<? extends Enum> enumClass;

    EnumOutputParser(Class<? extends Enum> enumClass) {
        this.enumClass = ValidationUtils.ensureNotNull(enumClass, "enumClass");
    }

    @Override
    public Enum parse(String string) {
        string = this.trimAndRemoveBracketsIfPresent(string);
        for (Enum enumConstant : this.enumClass.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(string)) continue;
            return enumConstant;
        }
        throw new RuntimeException("Unknown enum value: " + string);
    }

    @Override
    public String formatInstructions() {
        try {
            Enum[] enumConstants = this.enumClass.getEnumConstants();
            if (enumConstants.length == 0) {
                throw new IllegalArgumentException("Should be at least one enum constant defined.");
            }
            StringBuilder instruction = new StringBuilder();
            instruction.append("\nYou must answer strictly with one of these enums:");
            for (Enum enumConstant : enumConstants) {
                instruction.append("\n").append(enumConstant.name().toUpperCase(Locale.ROOT));
                Optional<String> optionalEnumDescription = EnumOutputParser.getEnumDescription(this.enumClass, enumConstant);
                optionalEnumDescription.ifPresent(description -> instruction.append(" - ").append((String)description));
            }
            return instruction.toString();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    static Optional<String> getEnumDescription(Class<? extends Enum> enumClass, Enum enumConstant) throws NoSuchFieldException {
        Description annotation;
        Field field = enumClass.getDeclaredField(enumConstant.name());
        if (field.isAnnotationPresent(Description.class) && (annotation = field.getAnnotation(Description.class)) != null) {
            return Optional.of(String.join((CharSequence)" ", annotation.value()));
        }
        return Optional.empty();
    }

    private String trimAndRemoveBracketsIfPresent(String string) {
        if ((string = string.trim()).startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        return string.trim();
    }
}

