/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchVariableException;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class ConvertVariableProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
RouteIdAware,
CamelContextAware {
    private CamelContext camelContext;
    private VariableRepositoryFactory factory;
    private String id;
    private String routeId;
    private final String name;
    private final Expression variableName;
    private final String toName;
    private final Expression toVariableName;
    private final Class<?> type;
    private final String charset;
    private final boolean mandatory;

    public ConvertVariableProcessor(String name, Expression variableName, String toName, Expression toVariableName, Class<?> type, String charset, boolean mandatory) {
        ObjectHelper.notNull(variableName, "variableName");
        ObjectHelper.notNull(type, "type", this);
        this.name = name;
        this.variableName = variableName;
        this.toName = toName;
        this.toVariableName = toVariableName;
        this.type = type;
        this.charset = IOHelper.normalizeCharset(charset);
        this.mandatory = mandatory;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object value;
        String name;
        String key = name = this.variableName.evaluate(exchange, String.class);
        String targetName = this.toVariableName != null ? this.toVariableName.evaluate(exchange, String.class) : name;
        VariableRepository repo = null;
        String id = StringHelper.before(key, ":");
        if (id != null) {
            key = StringHelper.after(key, ":");
            repo = this.factory.getVariableRepository(id);
            if (repo == null) {
                throw new IllegalArgumentException("VariableRepository with id: " + id + " does not exist");
            }
            value = repo.getVariable(key);
        } else {
            value = exchange.getVariable(key);
        }
        if (value == null && this.mandatory) {
            throw new NoSuchVariableException(exchange, name);
        }
        if (value == null) {
            return;
        }
        String originalCharsetName = null;
        if (this.charset != null) {
            originalCharsetName = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.charset);
        }
        value = this.mandatory ? exchange.getContext().getTypeConverter().mandatoryConvertTo(this.type, exchange, value) : exchange.getContext().getTypeConverter().convertTo(this.type, exchange, value);
        if (repo != null) {
            repo.setVariable(targetName, value);
        } else {
            exchange.setVariable(targetName, value);
        }
        if (this.charset != null) {
            if (originalCharsetName != null && !originalCharsetName.isEmpty()) {
                exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)originalCharsetName);
            } else {
                exchange.removeProperty(ExchangePropertyKey.CHARSET_NAME);
            }
        }
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getToName() {
        return this.toName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    protected void doBuild() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext");
        this.factory = this.camelContext.getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class);
    }
}

