/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.core;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.Metadata;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.langchain4j.core.LangChain4j;

@Converter(generateLoader=true)
public class LangChain4jConverter {
    @Converter
    public static Document toDocument(String value, Exchange exchange) {
        return Document.document(value, LangChain4jConverter.toMetadata(exchange));
    }

    private static Metadata toMetadata(Exchange exchange) {
        if (exchange == null) {
            return new Metadata();
        }
        if (exchange.getMessage() == null) {
            return new Metadata();
        }
        HashMap<String, Object> metadata = null;
        Map<String, Object> headers = exchange.getMessage().getHeaders();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (!entry.getKey().startsWith("langchain4j.metadata.")) continue;
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            metadata.put(entry.getKey().substring(LangChain4j.METADATA_PREFIX_LEN), entry.getValue());
        }
        return metadata != null ? Metadata.from(metadata) : new Metadata();
    }
}

