/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.ModDnAva;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;

public class MoveAndRenameOperationContext
extends RenameOperationContext {
    private Dn newSuperiorDn;
    private Map<String, List<ModDnAva>> modifiedAvas;

    public MoveAndRenameOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.MOVE_AND_RENAME));
        }
    }

    public MoveAndRenameOperationContext(CoreSession session, Dn oldDn, Dn newSuperiorDn, Rdn newRdn, boolean delOldRdn) {
        super(session, oldDn, newRdn, delOldRdn);
        this.newSuperiorDn = newSuperiorDn;
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.MOVE_AND_RENAME));
        }
        try {
            this.newDn = newSuperiorDn.add(newRdn);
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalArgumentException(lide.getMessage(), lide);
        }
    }

    public MoveAndRenameOperationContext(CoreSession session, ModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest);
        this.newSuperiorDn = modifyDnRequest.getNewSuperior();
        if (!this.newSuperiorDn.isSchemaAware()) {
            try {
                this.newSuperiorDn = new Dn(session.getDirectoryService().getSchemaManager(), this.newSuperiorDn);
            }
            catch (LdapInvalidDnException lide) {
                throw new IllegalStateException(I18n.err(I18n.ERR_325, modifyDnRequest), lide);
            }
        }
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.MOVE_AND_RENAME));
        }
        if (this.newSuperiorDn == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_325, modifyDnRequest));
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
        try {
            this.newDn = this.newSuperiorDn.add(this.newRdn);
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalStateException(I18n.err(I18n.ERR_325, modifyDnRequest), lide);
        }
    }

    public Dn getNewSuperiorDn() {
        return this.newSuperiorDn;
    }

    public void setNewSuperiorDn(Dn newSuperiorDn) {
        this.newSuperiorDn = newSuperiorDn;
    }

    @Override
    public String toString() {
        return "ReplaceContext for old Dn '" + this.getDn().getName() + "' : " + this.newDn;
    }

    public Map<String, List<ModDnAva>> getModifiedAvas() {
        return this.modifiedAvas;
    }

    public void setModifiedAvas(Map<String, List<ModDnAva>> modifiedAvas) {
        this.modifiedAvas = modifiedAvas;
    }
}

