/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.leveldb.LevelDBCamelCodec;
import org.apache.camel.component.leveldb.LevelDBFile;
import org.apache.camel.component.leveldb.LevelDBSerializer;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="bean", description="Aggregation repository that uses LevelDB to store exchanges.", annotations={"interfaceName=org.apache.camel.spi.AggregationRepository"})
@Configurer(metadataOnly=true)
public class LevelDBAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LevelDBAggregationRepository.class);
    private LevelDBFile levelDBFile;
    private LevelDBCamelCodec codec;
    @Metadata(description="Name of file to use for storing data", required=true)
    private String persistentFileName;
    @Metadata(description="Name of repository", required=true)
    private String repositoryName;
    @Metadata(description="Whether LevelDB should sync writes")
    private boolean sync;
    @Metadata(label="advanced", description="Whether to return the old exchange when adding new exchanges to the repository")
    private boolean returnOldExchange;
    @Metadata(description="Whether or not recovery is enabled", defaultValue="true")
    private boolean useRecovery = true;
    @Metadata(description="Sets the interval between recovery scans", defaultValue="5000")
    private long recoveryInterval = 5000L;
    @Metadata(description="Sets an optional limit of the number of redelivery attempt of recovered Exchange should be attempted, before its exhausted. When this limit is hit, then the Exchange is moved to the dead letter channel.")
    private int maximumRedeliveries;
    @Metadata(description="Sets an optional dead letter channel which exhausted recovered Exchange should be send to.")
    private String deadLetterUri;
    @Metadata(label="advanced", description="Whether headers on the Exchange that are Java objects and Serializable should be included and saved to the repository")
    private boolean allowSerializedHeaders;
    @Metadata(label="advanced", description="To use a custom serializer for LevelDB")
    private LevelDBSerializer serializer;

    public LevelDBAggregationRepository() {
    }

    public LevelDBAggregationRepository(String repositoryName) {
        StringHelper.notEmpty(repositoryName, "repositoryName");
        this.repositoryName = repositoryName;
    }

    public LevelDBAggregationRepository(String repositoryName, String persistentFileName) {
        StringHelper.notEmpty(repositoryName, "repositoryName");
        StringHelper.notEmpty(persistentFileName, "persistentFileName");
        this.repositoryName = repositoryName;
        this.persistentFileName = persistentFileName;
    }

    public LevelDBAggregationRepository(String repositoryName, LevelDBFile levelDBFile) {
        StringHelper.notEmpty(repositoryName, "repositoryName");
        ObjectHelper.notNull(levelDBFile, "levelDBFile");
        this.levelDBFile = levelDBFile;
        this.repositoryName = repositoryName;
    }

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        LOG.debug("Adding key [{}] -> {}", (Object)key, (Object)exchange);
        try {
            byte[] lDbKey = LevelDBAggregationRepository.keyBuilder(this.repositoryName, key);
            byte[] exchangeBuffer = this.codec().marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
            byte[] rc = null;
            if (this.isReturnOldExchange()) {
                rc = this.levelDBFile.getDb().get(lDbKey);
            }
            LOG.trace("Adding key index {} for repository {}", (Object)key, (Object)this.repositoryName);
            this.levelDBFile.getDb().put(lDbKey, exchangeBuffer, this.levelDBFile.getWriteOptions());
            LOG.trace("Added key index {}", (Object)key);
            if (rc == null) {
                return null;
            }
            if (this.isReturnOldExchange()) {
                return this.codec().unmarshallExchange(camelContext, rc);
            }
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Error adding to repository " + this.repositoryName + " with key " + key, e);
        }
        return null;
    }

    @Override
    public Exchange get(CamelContext camelContext, String key) {
        Exchange answer = null;
        try {
            byte[] lDbKey = LevelDBAggregationRepository.keyBuilder(this.repositoryName, key);
            LOG.trace("Getting key index {}", (Object)key);
            byte[] rc = this.levelDBFile.getDb().get(lDbKey);
            if (rc != null) {
                answer = this.codec().unmarshallExchange(camelContext, rc);
            }
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Error getting key " + key + " from repository " + this.repositoryName, e);
        }
        LOG.debug("Getting key  [{}] -> {}", (Object)key, (Object)answer);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        block5: {
            LOG.debug("Removing key [{}]", (Object)key);
            try {
                byte[] lDbKey = LevelDBAggregationRepository.keyBuilder(this.repositoryName, key);
                String exchangeId = exchange.getExchangeId();
                byte[] exchangeBuffer = this.codec().marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
                byte[] rc = this.levelDBFile.getDb().get(lDbKey);
                if (rc == null) break block5;
                try (WriteBatch batch = this.levelDBFile.getDb().createWriteBatch();){
                    batch.delete(lDbKey);
                    LOG.trace("Removed key index {} -> {}", (Object)key, (Object)rc);
                    byte[] confirmedLDBKey = LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), exchangeId);
                    batch.put(confirmedLDBKey, exchangeBuffer);
                    LOG.trace("Added confirm index {} for repository {}", (Object)exchangeId, (Object)this.getRepositoryNameCompleted());
                    this.levelDBFile.getDb().write(batch, this.levelDBFile.getWriteOptions());
                }
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Error removing key " + key + " from repository " + this.repositoryName, e);
            }
        }
    }

    @Override
    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.debug("Confirming exchangeId [{}]", (Object)exchangeId);
        byte[] confirmedLDBKey = LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), exchangeId);
        byte[] rc = this.levelDBFile.getDb().get(confirmedLDBKey);
        if (rc != null) {
            this.levelDBFile.getDb().delete(confirmedLDBKey);
            LOG.trace("Removed confirm index {} -> {}", (Object)exchangeId, (Object)rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (!this.isRunAllowed()) {
            return null;
        }
        DBIterator it = this.levelDBFile.getDb().iterator();
        try {
            String prefix = this.repositoryName + "\u0000";
            it.seek(LevelDBAggregationRepository.keyBuilder(this.repositoryName, ""));
            while (it.hasNext()) {
                if (!this.isRunAllowed()) {
                    break;
                }
                String keyBuffer = LevelDBAggregationRepository.asString(it.peekNext().getKey());
                if (!keyBuffer.startsWith(prefix)) {
                    break;
                }
                String key = keyBuffer.substring(prefix.length());
                LOG.trace("getKey [{}]", (Object)key);
                keys.add(key);
                it.next();
            }
        }
        finally {
            IOHelper.close((Closeable)it);
        }
        return Collections.unmodifiableSet(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> scan(CamelContext camelContext) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        if (!this.isRunAllowed()) {
            return null;
        }
        DBIterator it = this.levelDBFile.getDb().iterator();
        try {
            String prefix = this.getRepositoryNameCompleted() + "\u0000";
            it.seek(LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), ""));
            while (it.hasNext()) {
                String keyBuffer = LevelDBAggregationRepository.asString(it.peekNext().getKey());
                if (!keyBuffer.startsWith(prefix)) {
                    break;
                }
                String exchangeId = keyBuffer.substring(prefix.length());
                LOG.trace("Scan exchangeId [{}]", (Object)exchangeId);
                answer.add(exchangeId);
                it.next();
            }
        }
        finally {
            IOHelper.close((Closeable)it);
        }
        if (answer.isEmpty()) {
            LOG.trace("Scanned and found no exchange to recover.");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Scanned and found {} exchange(s) to recover (note some of them may already be in progress).", (Object)answer.size());
        }
        return answer;
    }

    @Override
    public Exchange recover(CamelContext camelContext, String exchangeId) {
        Exchange answer = null;
        try {
            byte[] completedLDBKey = LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), exchangeId);
            byte[] rc = this.levelDBFile.getDb().get(completedLDBKey);
            if (rc != null) {
                answer = this.codec().unmarshallExchange(camelContext, rc);
            }
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Error recovering exchangeId " + exchangeId + " from repository " + this.repositoryName, e);
        }
        LOG.debug("Recovering exchangeId [{}] -> {}", (Object)exchangeId, (Object)answer);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(String repositoryName) {
        DBIterator it = this.levelDBFile.getDb().iterator();
        String prefix = repositoryName + "\u0000";
        int count = 0;
        try {
            it.seek(LevelDBAggregationRepository.keyBuilder(repositoryName, ""));
            while (it.hasNext()) {
                if (!LevelDBAggregationRepository.asString(it.peekNext().getKey()).startsWith(prefix)) {
                    break;
                }
                ++count;
                it.next();
            }
        }
        finally {
            IOHelper.close((Closeable)it);
        }
        LOG.debug("Size of repository [{}] -> {}", (Object)repositoryName, (Object)count);
        return count;
    }

    public LevelDBFile getLevelDBFile() {
        return this.levelDBFile;
    }

    public void setLevelDBFile(LevelDBFile levelDBFile) {
        this.levelDBFile = levelDBFile;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private String getRepositoryNameCompleted() {
        return this.repositoryName + "-completed";
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isReturnOldExchange() {
        return this.returnOldExchange;
    }

    public void setReturnOldExchange(boolean returnOldExchange) {
        this.returnOldExchange = returnOldExchange;
    }

    @Override
    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    @Override
    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    @Override
    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    @Override
    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    @Override
    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    @Override
    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    @Override
    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    @Override
    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    @Override
    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public String getPersistentFileName() {
        return this.persistentFileName;
    }

    public void setPersistentFileName(String persistentFileName) {
        this.persistentFileName = persistentFileName;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.levelDBFile == null && this.persistentFileName != null) {
            this.levelDBFile = new LevelDBFile();
            this.levelDBFile.setSync(this.isSync());
            this.levelDBFile.setFileName(this.persistentFileName);
        }
        ObjectHelper.notNull(this.levelDBFile, "Either set a persistentFileName or a levelDBFile");
        ObjectHelper.notNull(this.repositoryName, "repositoryName");
        ServiceHelper.startService(this.levelDBFile);
        int current = this.size(this.getRepositoryName());
        int completed = this.size(this.getRepositoryNameCompleted());
        if (current > 0) {
            LOG.info("On startup there are {} aggregate exchanges (not completed) in repository: {}", (Object)current, (Object)this.getRepositoryName());
        } else {
            LOG.info("On startup there are no existing aggregate exchanges (not completed) in repository: {}", (Object)this.getRepositoryName());
        }
        if (completed > 0) {
            LOG.warn("On startup there are {} completed exchanges to be recovered in repository: {}", (Object)completed, (Object)this.getRepositoryNameCompleted());
        } else {
            LOG.info("On startup there are no completed exchanges to be recovered in repository: {}", (Object)this.getRepositoryNameCompleted());
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.levelDBFile);
    }

    public static byte[] keyBuilder(String repo, String key) {
        return (repo + "\u0000" + key).getBytes(StandardCharsets.UTF_8);
    }

    public static String asString(byte[] value) {
        if (value == null) {
            return null;
        }
        return new String(value, StandardCharsets.UTF_8);
    }

    public LevelDBSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(LevelDBSerializer serializer) {
        this.serializer = serializer;
    }

    public LevelDBCamelCodec codec() {
        if (this.codec == null) {
            this.codec = new LevelDBCamelCodec(this.serializer);
        }
        return this.codec;
    }
}

