/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.leveldb.serializer.AbstractLevelDBSerializer;
import org.apache.camel.support.DefaultExchangeHolder;

public class DefaultLevelDBSerializer
extends AbstractLevelDBSerializer {
    @Override
    public byte[] serializeKey(String key) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(key);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public String deserializeKey(byte[] buffer) throws IOException {
        String string;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer));
        try {
            string = (String)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Content has to be serialized String.", e);
            }
        }
        ois.close();
        return string;
    }

    @Override
    public byte[] serializeExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders) throws IOException {
        return this.serializeExchange(exchange, allowSerializedHeaders, h2 -> {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(h2);
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
        });
    }

    @Override
    public Exchange deserializeExchange(CamelContext camelContext, byte[] buffer) throws IOException {
        return this.deserializeExchange(camelContext, buffer, b -> {
            DefaultExchangeHolder defaultExchangeHolder;
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer));
            try {
                defaultExchangeHolder = (DefaultExchangeHolder)ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Content has to be serialized String.", e);
                }
            }
            ois.close();
            return defaultExchangeHolder;
        });
    }
}

