/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsonable;
import org.apache.camel.util.json.Jsoner;

public final class DefaultBacklogTracerEventMessage
implements BacklogTracerEventMessage {
    private final StopWatch watch = new StopWatch();
    private final boolean first;
    private final boolean last;
    private final long uid;
    private final long timestamp;
    private final String location;
    private final String routeId;
    private final String toNode;
    private final String exchangeId;
    private final String threadName;
    private String endpointUri;
    private boolean remoteEndpoint;
    private String endpointServiceUrl;
    private String endpointServiceProtocol;
    private Map<String, String> endpointServiceMetadata;
    private final boolean rest;
    private final boolean template;
    private final String messageAsXml;
    private final String messageAsJSon;
    private String exceptionAsXml;
    private String exceptionAsJSon;
    private long duration;
    private boolean done;

    public DefaultBacklogTracerEventMessage(boolean first, boolean last, long uid, long timestamp, String location, String routeId, String toNode, String exchangeId, boolean rest, boolean template, String messageAsXml, String messageAsJSon) {
        this.first = first;
        this.last = last;
        this.uid = uid;
        this.timestamp = timestamp;
        this.location = location;
        this.routeId = routeId;
        this.toNode = toNode;
        this.exchangeId = exchangeId;
        this.rest = rest;
        this.template = template;
        this.messageAsXml = messageAsXml;
        this.messageAsJSon = messageAsJSon;
        this.threadName = Thread.currentThread().getName();
    }

    public void doneProcessing() {
        this.done = true;
        this.duration = this.watch.taken();
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public boolean isFirst() {
        return this.first;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public boolean isRest() {
        return this.rest;
    }

    @Override
    public boolean isTemplate() {
        return this.template;
    }

    @Override
    public String getToNode() {
        return this.toNode;
    }

    @Override
    public String getExchangeId() {
        return this.exchangeId;
    }

    @Override
    public String getProcessingThreadName() {
        return this.threadName;
    }

    @Override
    public String getMessageAsXml() {
        return this.messageAsXml;
    }

    @Override
    public String getMessageAsJSon() {
        return this.messageAsJSon;
    }

    @Override
    public long getElapsed() {
        return this.done ? this.duration : this.watch.taken();
    }

    public void setElapsed(long elapsed) {
        this.duration = elapsed;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isFailed() {
        return this.hasException();
    }

    @Override
    public boolean hasException() {
        return this.exceptionAsXml != null || this.exceptionAsJSon != null;
    }

    @Override
    public String getExceptionAsXml() {
        return this.exceptionAsXml;
    }

    @Override
    public void setExceptionAsXml(String exceptionAsXml) {
        this.exceptionAsXml = exceptionAsXml;
    }

    @Override
    public String getExceptionAsJSon() {
        return this.exceptionAsJSon;
    }

    @Override
    public void setExceptionAsJSon(String exceptionAsJSon) {
        this.exceptionAsJSon = exceptionAsJSon;
    }

    @Override
    public String getEndpointUri() {
        return this.endpointUri;
    }

    @Override
    public boolean isRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public void setRemoteEndpoint(boolean remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    public String getEndpointServiceUrl() {
        return this.endpointServiceUrl;
    }

    public void setEndpointServiceUrl(String endpointServiceUrl) {
        this.endpointServiceUrl = endpointServiceUrl;
    }

    @Override
    public String getEndpointServiceProtocol() {
        return this.endpointServiceProtocol;
    }

    public void setEndpointServiceProtocol(String endpointServiceProtocol) {
        this.endpointServiceProtocol = endpointServiceProtocol;
    }

    @Override
    public Map<String, String> getEndpointServiceMetadata() {
        return this.endpointServiceMetadata;
    }

    public void setEndpointServiceMetadata(Map<String, String> endpointServiceMetadata) {
        this.endpointServiceMetadata = endpointServiceMetadata;
    }

    public String toString() {
        return "DefaultBacklogTracerEventMessage[" + this.exchangeId + " at " + this.toNode + "]";
    }

    @Override
    public String toXml(int indent) {
        StringBuilder prefix = new StringBuilder();
        prefix.append(" ".repeat(indent));
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)prefix).append("<").append("backlogTracerEventMessage").append(">\n");
        sb.append((CharSequence)prefix).append("  <uid>").append(this.uid).append("</uid>\n");
        sb.append((CharSequence)prefix).append("  <first>").append(this.first).append("</first>\n");
        sb.append((CharSequence)prefix).append("  <last>").append(this.last).append("</last>\n");
        sb.append((CharSequence)prefix).append("  <rest>").append(this.rest).append("</rest>\n");
        sb.append((CharSequence)prefix).append("  <template>").append(this.template).append("</template>\n");
        String ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.timestamp);
        sb.append((CharSequence)prefix).append("  <timestamp>").append(ts).append("</timestamp>\n");
        sb.append((CharSequence)prefix).append("  <elapsed>").append(this.getElapsed()).append("</elapsed>\n");
        sb.append((CharSequence)prefix).append("  <threadName>").append(this.getProcessingThreadName()).append("</threadName>\n");
        sb.append((CharSequence)prefix).append("  <done>").append(this.isDone()).append("</done>\n");
        sb.append((CharSequence)prefix).append("  <failed>").append(this.isFailed()).append("</failed>\n");
        if (this.getLocation() != null) {
            sb.append((CharSequence)prefix).append("  <location>").append(this.getLocation()).append("</location>\n");
        }
        sb.append((CharSequence)prefix).append("  <routeId>").append(this.routeId != null ? this.routeId : "").append("</routeId>\n");
        if (this.endpointUri != null) {
            sb.append((CharSequence)prefix).append("  <endpointUri>").append(this.endpointUri).append("</endpointUri>\n");
            sb.append((CharSequence)prefix).append("  <remoteEndpoint>").append(this.remoteEndpoint).append("</remoteEndpoint>\n");
        }
        if (this.toNode != null) {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.toNode).append("</toNode>\n");
        } else {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.routeId).append("</toNode>\n");
        }
        sb.append((CharSequence)prefix).append("  <exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        if (this.endpointServiceUrl != null) {
            sb.append((CharSequence)prefix).append("  <endpointService>\n");
            sb.append((CharSequence)prefix).append("    <serviceUrl>").append(this.endpointServiceUrl).append("</serviceUrl>\n");
            if (this.endpointServiceProtocol != null) {
                sb.append((CharSequence)prefix).append("    <serviceProtocol>").append(this.endpointServiceProtocol).append("</serviceProtocol>\n");
            }
            if (this.endpointServiceMetadata != null) {
                sb.append((CharSequence)prefix).append("    <serviceMetadata>\n");
                this.endpointServiceMetadata.forEach((k, v) -> sb.append((CharSequence)prefix).append("      <").append((String)k).append(">").append((String)v).append("</").append((String)k).append(">\n"));
                sb.append((CharSequence)prefix).append("    </serviceMetadata>\n");
            }
            sb.append((CharSequence)prefix).append("  </endpointService>\n");
        }
        sb.append((CharSequence)prefix).append(this.messageAsXml).append("\n");
        if (this.exceptionAsXml != null) {
            sb.append((CharSequence)prefix).append(this.exceptionAsXml).append("\n");
        }
        sb.append((CharSequence)prefix).append("</").append("backlogTracerEventMessage").append(">");
        return sb.toString();
    }

    @Override
    public String toJSon(int indent) {
        Jsonable jo = (Jsonable)((Object)this.asJSon());
        if (indent > 0) {
            return Jsoner.prettyPrint(jo.toJson(), indent);
        }
        return Jsoner.prettyPrint(jo.toJson());
    }

    @Override
    public Map<String, Object> asJSon() {
        JsonObject msg2;
        JsonObject jo = new JsonObject();
        jo.put("uid", this.uid);
        jo.put("first", this.first);
        jo.put("last", this.last);
        jo.put("rest", this.rest);
        jo.put("template", this.template);
        if (this.location != null) {
            jo.put("location", this.location);
        }
        if (this.endpointUri != null) {
            jo.put("endpointUri", this.endpointUri);
            jo.put("remoteEndpoint", this.remoteEndpoint);
        }
        if (this.routeId != null) {
            jo.put("routeId", this.routeId);
        }
        if (this.toNode != null) {
            jo.put("nodeId", this.toNode);
        }
        if (this.exchangeId != null) {
            jo.put("exchangeId", this.exchangeId);
        }
        if (this.timestamp > 0L) {
            jo.put("timestamp", this.timestamp);
        }
        jo.put("elapsed", this.getElapsed());
        jo.put("threadName", this.getProcessingThreadName());
        jo.put("done", this.isDone());
        jo.put("failed", this.isFailed());
        if (this.endpointServiceUrl != null) {
            JsonObject es = new JsonObject();
            es.put("serviceUrl", this.endpointServiceUrl);
            if (this.endpointServiceProtocol != null) {
                es.put("serviceProtocol", this.endpointServiceProtocol);
            }
            if (this.endpointServiceMetadata != null) {
                es.put("serviceMetadata", this.endpointServiceMetadata);
            }
            jo.put("endpointService", es);
        }
        try {
            msg2 = (JsonObject)Jsoner.deserialize(this.messageAsJSon);
            msg2 = (JsonObject)msg2.getMap("message");
            jo.put("message", msg2);
            msg2 = (JsonObject)msg2.getMap("body");
            Object body = msg2.get("value");
            if ("[Body is null]".equals(body)) {
                msg2.replace("value", null);
            }
        }
        catch (Exception msg2) {
            // empty catch block
        }
        if (this.exceptionAsJSon != null) {
            try {
                msg2 = (JsonObject)Jsoner.deserialize(this.exceptionAsJSon);
                jo.put("exception", msg2.get("exception"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jo;
    }
}

