/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;
import org.apache.camel.support.PluginHelper;

public class DefaultDependencyInjectionAnnotationFactory
implements CamelDependencyInjectionAnnotationFactory,
CamelContextAware {
    private CamelContext camelContext;

    public DefaultDependencyInjectionAnnotationFactory(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Runnable createBindToRegistryFactory(String id, Object bean, String beanName, boolean beanPostProcess) {
        return () -> {
            if (beanPostProcess) {
                try {
                    CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor(this.camelContext);
                    beanPostProcessor.postProcessBeforeInitialization(bean, beanName);
                    beanPostProcessor.postProcessAfterInitialization(bean, beanName);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException(e);
                }
            }
            CamelContextAware.trySetCamelContext(bean, this.camelContext);
            this.camelContext.getRegistry().bind(id, bean);
        };
    }
}

