/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StaticService;
import org.apache.camel.impl.engine.DefaultResourceResolvers;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class DefaultResourceLoader
extends ServiceSupport
implements ResourceLoader,
StaticService {
    public static final String RESOURCE_LOADER_KEY_PREFIX = "resource-loader-";
    private final Map<String, ResourceResolver> resolvers;
    private CamelContext camelContext;
    private ResourceResolver fallbackResolver;

    public DefaultResourceLoader() {
        this(null);
    }

    public DefaultResourceLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resolvers = new ConcurrentHashMap<String, ResourceResolver>();
        this.fallbackResolver = new DefaultResourceResolvers.ClasspathResolver(){

            @Override
            public Resource resolve(String location) {
                return super.resolve("classpath:" + location);
            }
        };
        this.fallbackResolver.setCamelContext(camelContext);
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.fallbackResolver);
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.resolvers.values());
        this.resolvers.clear();
    }

    public ResourceResolver getFallbackResolver() {
        return this.fallbackResolver;
    }

    public void setFallbackResolver(ResourceResolver fallbackResolver) {
        this.fallbackResolver = fallbackResolver;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.fallbackResolver.setCamelContext(this.camelContext);
    }

    @Override
    public Resource resolveResource(String uri) {
        ObjectHelper.notNull(uri, "Resource uri must not be null");
        String scheme = StringHelper.before(uri, ":");
        if (scheme == null) {
            return this.fallbackResolver.resolve(uri);
        }
        ResourceResolver rr = this.getResourceResolver(scheme);
        if (rr == null) {
            throw new IllegalArgumentException("Cannot find a ResourceResolver in classpath supporting the scheme: " + scheme);
        }
        return rr.resolve(uri);
    }

    protected boolean hasResourceResolver(String scheme) {
        ResourceResolver answer = this.getCamelContext().getRegistry().lookupByNameAndType(RESOURCE_LOADER_KEY_PREFIX + scheme, ResourceResolver.class);
        if (answer == null) {
            answer = this.resolvers.get(scheme);
        }
        return answer != null;
    }

    private ResourceResolver getResourceResolver(String scheme) {
        ResourceResolver answer = this.getCamelContext().getRegistry().lookupByNameAndType(RESOURCE_LOADER_KEY_PREFIX + scheme, ResourceResolver.class);
        if (answer == null) {
            answer = this.resolvers.computeIfAbsent(scheme, this::resolveService);
        }
        return answer;
    }

    private ResourceResolver resolveService(String scheme) {
        FactoryFinder finder;
        CamelContext context = this.getCamelContext();
        ResourceResolver rr = ResolverHelper.resolveService(context, finder = context.getCamelContextExtension().getBootstrapFactoryFinder("META-INF/services/org/apache/camel/resource-resolver/"), scheme, ResourceResolver.class).orElse(null);
        if (rr != null) {
            CamelContextAware.trySetCamelContext(rr, this.getCamelContext());
            ServiceHelper.startService(rr);
        }
        return rr;
    }
}

